<?php
// *************************************************************************
// *                                                                       *
// * DEPRIXA BASIC -  Freight Forwarding & Shipping Software Solutions     *
// * Copyright (c) JAOMWEB. All Rights Reserved                            *
// *                                                                       *
// *************************************************************************
// *                                                                       *
// * Email: support@jaom.info                                              *
// * Website: https://deprixa.link/documentation/                          *
// *                                                                       *
// *************************************************************************
// *                                                                       *
// * This software is furnished under a license and may be used and copied *
// * only  in  accordance  with  the  terms  of such  license and with the *
// * inclusion of the above copyright notice.                              *
// * If you Purchased from Codecanyon, Please read the full License from   *
// * here- http://codecanyon.net/licenses/standard                         *
// *                                                                       *
// *************************************************************************



require_once("../../loader.php");
require_once("../../helpers/querys.php");

session_start();


$errors = array();

if (empty($_POST['total_pay']))
  $errors['total_pay'] = 'Please Enter total pay';


if (empty($_POST['mode_pay']))
  $errors['mode_pay'] = 'Please Enter mode payment';

if (empty($_POST['amount']))
  $errors['amount'] = 'Please Enter amount';

if (empty($_POST['balance']))
  $errors['balance'] = 'Please Enter balance';

if ($_POST['total_pay'] > $_POST['balance'])
  $errors['eees'] = 'The amount to be collected must be less than the total balance.';



if (empty($errors)) {

  $data = array(
    'total' => cdp_sanitize($_POST['total_pay']),
    'payment_type' => cdp_sanitize($_POST['mode_pay']),
    'notes' => cdp_sanitize($_POST['notes']),
    'charge_id' => cdp_sanitize($_POST['charge_id']),
  );


  $insert = cdp_updateCharges($data);

  if ($insert) {

    $messages[] = "charge update successfully!";
  } else {

    $errors['critical_error'] = "the insert was not completed";
  }
}


if (!empty($errors)) {
?>

  <div class="alert customize-alert alert-dismissible alert-light-danger text-danger fade show"
    role="alert" id="success-alert">
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
            <i data-feather="x" class="fill-white text-danger feather-sm"></i>
        </button>
        <div class="d-flex align-items-center font-medium me-3 me-md-0">
            <i class="bi-exclamation-diamond text-danger me-2"></i>
             <?php
            foreach ($errors as $error) { ?>
                    <?php
                    echo $error;

                    ?>
            <?php

            }
            ?>
        </div>

    </div>



<?php
}

if (isset($messages)) {

?>

  <div class="alert customize-alert alert-dismissible alert-light-info text-info fade show" role="alert" id="success-alert">
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        <div class="d-flex align-items-center font-medium">
            <p>
            <i class="bi-check2-all text-info me-2"></i>
             <?php
            foreach ($messages as $message) {
                echo $message;
            }
            ?>

            </p>
        </div>
    </div>

<?php
}
?>