<?php
// *************************************************************************
// *                                                                       *
// * DEPRIXA BASIC -  Freight Forwarding & Shipping Software Solutions     *
// * Copyright (c) JAOMWEB. All Rights Reserved                            *
// *                                                                       *
// *************************************************************************
// *                                                                       *
// * Email: support@jaom.info                                              *
// * Website: https://deprixa.link/documentation/                          *
// *                                                                       *
// *************************************************************************
// *                                                                       *
// * This software is furnished under a license and may be used and copied *
// * only  in  accordance  with  the  terms  of such  license and with the *
// * inclusion of the above copyright notice.                              *
// * If you Purchased from Codecanyon, Please read the full License from   *
// * here- http://codecanyon.net/licenses/standard                         *
// *                                                                       *
// *************************************************************************



require_once("../../loader.php");

$db = new Conexion;
$user = new User;
$core = new Core;
$userData = $user->cdp_getUserData();

$search = cdp_sanitize($_REQUEST['search']);
$status_courier = intval($_REQUEST['status_courier']);

$sWhere = "";

if ($userData->userlevel == 3) {

	$sWhere .= " and  a.driver_id = '" . $_SESSION['userid'] . "'";
} else if ($userData->userlevel == 1) {

	$sWhere .= " and  a.sender_id = '" . $_SESSION['userid'] . "'";
} else {
	$sWhere .= "";
}
if ($search != null) {

	$sWhere .= " and  CONCAT(a.c_prefix,a.c_no) LIKE '%" . $search . "%'";
}
if ($status_courier > 0) {

	$sWhere .= " and  a.status_courier = '" . $status_courier . "'";
}


// // pagination variables
$page = (isset($_REQUEST['page']) && !empty($_REQUEST['page'])) ? $_REQUEST['page'] : 1;
$per_page = 10; //how much records you want to show
$adjacents  = 4; //gap between pages after number of adjacents
$offset = ($page - 1) * $per_page;


$sql = "SELECT   a.status_invoice, a.total_order, a.consolidate_id , a.c_prefix, a.c_no, a.c_date, a.sender_id, a.receiver_id, a.order_courier, a.order_pay_mode, a.status_courier, a.driver_id, a.order_service_options,  b.mod_style, b.color FROM cdb_consolidate as a
			 INNER JOIN cdb_styles as b ON a.status_courier = b.id
			 $sWhere
			  and a.status_courier!=14
			 order by a.consolidate_id  desc
			 ";


$query_count = $db->cdp_query($sql);
$db->cdp_execute();
$numrows = $db->cdp_rowCount();


$db->cdp_query($sql . " limit $offset, $per_page");
$data = $db->cdp_registros();

$total_pages = ceil($numrows / $per_page);


if ($numrows > 0) { ?>
	<div class="table-responsive">


		<table id="zero_config" class="table table-condensed table-hover table-striped custom-table-checkbox">
			<thead>
				<tr>
					<?php
					if ($userData->userlevel == 9) { ?>

						<th>
							<div class="custom-control custom-checkbox">
								<input type="checkbox" class="custom-control-input sl-all" id="cstall">
								<label class="custom-control-label" for="cstall"></label>
							</div>
						</th>
					<?php } else if ($userData->userlevel == 2) { ?>
						<th>
							<div class="custom-control custom-checkbox">
								<input type="checkbox" class="custom-control-input sl-all" id="cstall">
								<label class="custom-control-label" for="cstall"></label>
							</div>
						</th>
					<?php } ?>
					<th><b><?php echo $lang['ltracking'] ?></b></th>
					<th class="text-center"><b><?php echo $lang['ddate'] ?></b></th>
					<th class="text-center"><b><?php echo $lang['left1023'] ?></b></th>
					<th class="text-center"><b><?php echo $lang['lorigin'] ?></b></th>
					<th class="text-center"><b><?php echo $lang['ldestination'] ?></b></th>
					<th class="text-center"><b><?php echo $lang['lpayment'] ?></b></th>
					<th class="text-center"><b><?php echo $lang['lstatusshipment'] ?></b></th>
					<th class="text-center"><b><?php echo $lang['ship-all5'] ?></b></th>
					<th class="text-center"><b><?php echo $lang['lstatusinvoice'] ?></b></th>
					<th class="text-center"><b><?php
												//echo $lang['aaction']
												?></b></th>
				</tr>
			</thead>
			<tbody id="projects-tbl">


				<?php if (!$data) { ?>
					<tr>
						<td colspan="6">
							<?php echo "
				<i align='center' class='display-3 text-warning d-block'><img src='assets/images/alert/ohh_shipment.png' width='150' /></i>								
				", false; ?>
						</td>
					</tr>
				<?php } else { ?>

					<?php

					$count = 0;
					foreach ($data as $row) {

						$db->cdp_query("SELECT * FROM cdb_users where id= '" . $row->sender_id . "'");
						$sender_data = $db->cdp_registro();

						$db->cdp_query("SELECT * FROM cdb_users where id= '" . $row->receiver_id . "'");
						$receiver_data = $db->cdp_registro();

						$db->cdp_query("SELECT * FROM cdb_users where id= '" . $row->driver_id . "'");
						$driver_data = $db->cdp_registro();

						$db->cdp_query("SELECT * FROM cdb_courier_com where id= '" . $row->order_courier . "'");
						$courier_com = $db->cdp_registro();

						$db->cdp_query("SELECT * FROM cdb_met_payment where id= '" . $row->order_pay_mode . "'");
						$met_payment = $db->cdp_registro();

						$db->cdp_query("SELECT * FROM cdb_shipping_mode where id= '" . $row->order_service_options . "'");
						$order_service_options = $db->cdp_registro();

						$db->cdp_query("SELECT * FROM cdb_styles where id= '14'");
						$status_style_pickup = $db->cdp_registro();



						if ($row->status_invoice == 1) {

							$text_status = $lang['invoice_paid'];
							$label_class = "badge bg-light-success text-success fw-normal";
						} else if ($row->status_invoice == 2) {

							$text_status = $lang['invoice_pending'];
							$label_class = "badge bg-light-warning text-warning fw-normal";
						} else if ($row->status_invoice == 3) {
							$text_status = $lang['verify_payment'];
							$label_class = "badge bg-light-danger text-danger fw-normal";
						}




						$db->cdp_query("SELECT * FROM cdb_address_shipments where order_track='" . $row->c_prefix . $row->c_no . "'");
						$address_order = $db->cdp_registro();

					?>
						<tr class="card-hovera">
							<?php
							if ($userData->userlevel == 9) { ?>
								<td class="chb">
									<?php if ($row->status_courier != 8) { ?>
										<?php if ($row->status_courier != 21) { ?>

										<div class="custom-control custom-checkbox">
											<input type="checkbox" class="custom-control-input" value="<?php echo $row->c_no; ?>" name="checkbox[]" id="cst_<?php echo $count; ?>">
											<label class="custom-control-label" for="cst_<?php echo $count; ?>">&nbsp;</label>
										</div>
										<?php } ?>
									<?php } ?>
								</td>
							<?php } else if ($userData->userlevel == 2) { ?>
								<td class="chb">
									<?php if ($row->status_courier != 8) { ?>
										<?php if ($row->status_courier != 21) { ?>

										<div class="custom-control custom-checkbox">
											<input type="checkbox" class="custom-control-input" value="<?php echo $row->c_no; ?>" name="checkbox[]" id="cst_<?php echo $count; ?>">
											<label class="custom-control-label" for="cst_<?php echo $count; ?>">&nbsp;</label>
										</div>
										<?php } ?>
									<?php } ?>
								</td>
							<?php } ?>
							<td><b><a href="consolidate_view.php?id=<?php echo $row->consolidate_id; ?>"><?php echo $row->c_prefix . $row->c_no; ?></a></b></td>
							<td class="text-center">
								<?php echo $row->c_date; ?>
							</td>

							<td class="text-center">
								<?php echo $receiver_data->fname; ?> <?php echo $receiver_data->lname; ?>
							</td>

							<td class="text-center"><?php echo $address_order->sender_country; ?>-<?php echo $address_order->sender_city; ?></td>
							<td class="text-center"><?php echo $address_order->recipient_country; ?>-<?php echo $address_order->recipient_city; ?></td>
							<!-- <td class="text-center"><?php echo $courier_com->name_com; ?> | <?php echo $order_service_options->ship_mode; ?></td> -->
							<td class="text-center"><?php echo $met_payment->met_payment; ?></td>

							<td class="">

								<span style="background: <?php echo $row->color; ?>;" class="badge  fw-normal"><?php echo $row->mod_style; ?></span>

							</td>

							<td class="text-center">
								<b><?php echo $core->currency; ?></b> <?php echo number_format($row->total_order, 2, '.', ''); ?>
							</td>

							<td>
								<span class=" <?php echo $label_class; ?>"><?php echo $text_status; ?></span>

								<br>

								<?php if ($row->status_invoice == 2) { ?>
								<td class="text-center">
									<?php if ($userData->userlevel == 1) { ?>

											<button type="button" class="btn waves-effect waves-light btn-light-danger text-warning"><a href="add_payment_gateways_consolidate.php?id_order=<?php echo $row->consolidate_id; ?>"><i class="bi-credit-card" aria-hidden="true"></i> <?php echo $lang['leftorder268'] ?></a></button>

									<?php } ?>
								</td>
								<?php } ?>

							</td>

							<td align='center'>
								<div class="btn-group">
									<button type="button" class="btn btn-light-info text-info dropdown-toggle" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
										Action
									</button>
									<div class="dropdown-menu scrollable-menu">
										<a class="dropdown-item" href="consolidate_view.php?id=<?php echo $row->consolidate_id; ?>" title="<?php echo $lang['tooledit'] ?>"><i style="color:#343a40" class="fa fa-search"></i>&nbsp;<?php echo $lang['leftorder266'] ?></a>

										<?php if ($row->status_invoice == 2) { ?>
											<?php if ($userData->userlevel == 1) { ?>



												<a class="dropdown-item" href="add_payment_gateways_consolidate.php?id_order=<?php echo $row->consolidate_id; ?>">
													<i style="color:#343a40" class="fas fa-dollar-sign"></i>&nbsp;<?php echo $lang['leftorder154'] ?></a>


											<?php } ?>

										<?php } ?>

										<?php if ($row->status_invoice == 3) { ?>
											<?php if ($userData->userlevel != 1) { ?>


												<a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#detail_payment_packages" data-id="<?php echo $row->consolidate_id; ?>" data-customer="<?php echo $row->sender_id; ?>"><i style="color:#343a40" class="fas fa-dollar-sign"></i>&nbsp; <?php echo $lang['leftorder33'] ?></a>


											<?php } ?>

										<?php } ?>


										<?php if ($userData->userlevel != 1) { ?>

											<?php if ($userData->userlevel == 9) { ?>
												<?php if ($row->status_courier != 8) { ?>
													<?php if ($row->status_courier != 21) { ?>

													<a class="dropdown-item" href="consolidate_edit.php?id=<?php echo $row->consolidate_id; ?>" title="<?php echo $lang['tooledit'] ?>"><i style="color:#343a40" class="mdi mdi-pencil-box-outline"></i>&nbsp;<?php echo $lang['tooledit'] ?></a>
													<?php } ?>
												<?php } ?>
											<?php } ?>
										<?php } ?>

										<?php if ($row->status_courier != 21) { ?>
											<?php if ($userData->userlevel == 9 || $userData->userlevel == 2) { ?>

												<a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#modalDriver" data-id_shipment="<?php echo $row->consolidate_id; ?>" data-id_sender="<?php echo $row->sender_id; ?>"><i style="color:#ff0000" class="fas fa-car"></i>&nbsp; <?php echo $lang['left208'] ?></a>

											<?php } ?>


											<a class="dropdown-item" target="blank" href="print_consolidate.php?id=<?php echo $row->consolidate_id; ?>"> <i style="color:#343a40" class="mdi mdi-printer"></i>&nbsp;<?php echo $lang['toolprint'] ?></a>

											<a class="dropdown-item" href="print_label_consolidate.php?id=<?php echo $row->consolidate_id; ?>" target="_blank"> <i style="color:#343a40" class="mdi mdi-printer"></i>&nbsp;<?php echo $lang['toollabel'] ?> </a>


											<?php if ($userData->userlevel != 1) { ?>

												<?php if ($row->status_courier != 8) { ?>

													<a class="dropdown-item" href="consolidate_shipment_tracking.php?id=<?php echo $row->consolidate_id; ?>" title="<?php echo $lang['toolupdate'] ?>"><i style="color:#20c997" class="mdi mdi-map-marker-radius">&nbsp;</i><?php echo $lang['toolupdate'] ?></a>

													<a class="dropdown-item" href="consolidate_deliver_shipment.php?id=<?php echo $row->consolidate_id; ?>" title="<?php echo $lang['tooldeliver'] ?>"><i style="color:#2962FF" class="mdi mdi-package-up"></i>&nbsp;<?php echo $lang['tooldeliver'] ?></a>
													<?php if ($userData->userlevel != 3) { ?>

														<a class="dropdown-item" onclick="cdp_eliminar('<?php echo $row->consolidate_id; ?>');" target="_blank"> <i style="color:#f62d51" class="fas fa-times-circle"></i>&nbsp;<?php echo $lang['leftorder267'] ?></a>
													<?php } ?>
												<?php } ?>




												<?php if ($userData->userlevel == 9) { ?>

													<a class="dropdown-item" href="#" data-bs-toggle="modal" data-id="<?php echo $row->consolidate_id; ?>" data-email="<?php echo $sender_data->email; ?>" data-order="<?php echo $row->c_prefix . $row->c_no; ?>" data-bs-target="#myModal"><i class="fas fa-envelope"></i>&nbsp;<?php echo $lang['send-news2'] ?></a>

												<?php } ?>

											<?php } ?>
										<?php } ?>

									</div>
								</div>
							</td>


						</tr>
					<?php $count++;
					} ?>

				<?php } ?>
			</tbody>

		</table>


		<div class="pull-right">
			<?php echo cdp_paginate($page, $total_pages, $adjacents);	?>
		</div>

		<script src="dataJs/consolidate_ajax.js"></script>

	</div>
<?php } ?>