<?php
// *************************************************************************
// *                                                                       *
// * DEPRIXA BASIC -  Freight Forwarding & Shipping Software Solutions     *
// * Copyright (c) JAOMWEB. All Rights Reserved                            *
// *                                                                       *
// *************************************************************************
// *                                                                       *
// * Email: support@jaom.info                                              *
// * Website: https://deprixa.link/documentation/                          *
// *                                                                       *
// *************************************************************************
// *                                                                       *
// * This software is furnished under a license and may be used and copied *
// * only  in  accordance  with  the  terms  of such  license and with the *
// * inclusion of the above copyright notice.                              *
// * If you Purchased from Codecanyon, Please read the full License from   *
// * here- http://codecanyon.net/licenses/standard                         *
// *                                                                       *
// *************************************************************************



require_once("../../loader.php");
require_once("../../helpers/querys.php");
$user = new User;
$core = new Core;
$errors = array();

if (empty($_POST['fname']))

    $errors['fname'] = 'Please enter the name';
if (empty($_POST['lname']))

    $errors['lname'] = 'Please enter the last name';



if (empty($_POST['phone_custom']))

    $errors['phone_custom'] = 'Please enter the phone';

if (empty($_POST['address_modal_user']))

    $errors['address_modal_user'] = 'Please enter the address';

if (isset($_POST['register_customer_to_user']) && $_POST['register_customer_to_user'] == 1) {


    if (empty($_POST['password']))

        $errors['password'] = 'Enter a valid password.';


    if (empty($_POST['username']))

        $errors['username'] = 'Enter a valid username';

    if ($value = $user->cdp_usernameExists($_POST['username']))

        if ($value == 1)

            $errors['username'] = 'Username is too short (less than 4 characters long).';

    if ($value == 2)

        $errors['username'] = 'Invalid characters found in the username.';

    if ($value == 3)
        $errors['username'] = 'Sorry, this username is already taken';
}




if (empty($errors)) {




    $data = array(

        'lname' => cdp_sanitize($_POST['lname']),
        'fname' => cdp_sanitize($_POST['fname']),
        'phone' => cdp_sanitize($_POST['phone']),
        'email' => cdp_sanitize($_POST['email']),
        'userlevel' => '1',
        'active' => '1',
        'create_user' => '',
        'locker' => '',
        'username' => '',
        'password' => '',
        'created' => date("Y-m-d H:i:s"),

    );




    $data['create_user'] =null;

    if ($_POST['type_user'] == 'user_recipient') {

        $data['create_user'] = $_GET['sender'];
    }



    if (isset($_POST['register_customer_to_user']) && $_POST['register_customer_to_user'] == 1) {

        $data['password'] = password_hash($_POST['password'], PASSWORD_DEFAULT);

        $data['username'] = cdp_sanitize($_POST['username']);

        $data['locker'] = cdp_generarCodigo(6);
    }


    $db->cdp_query('INSERT INTO cdb_users
              (   

                  username,
                  password,
                  locker,
                  userlevel,
                  email,
                  fname,
                  lname,
                  created,
                  phone,
                  active,
                  create_user      
              )

              VALUES (

                  :username,
                  :password,
                  :locker,
                  :userlevel,
                  :email,
                  :fname,
                  :lname,
                  :created,           
                  :phone,
                  :active,
                  :create_user
                  
              )');

    $db->bind(':userlevel', $data['userlevel']);
    $db->bind(':locker', $data['locker']);
    $db->bind(':email', $data['email']);
    $db->bind(':fname', $data['fname']);
    $db->bind(':lname', $data['lname']);
    $db->bind(':phone', $data['phone']);
    $db->bind(':active', $data['active']);
    $db->bind(':create_user', $data['create_user']);
    $db->bind(':username', $data['username']);
    $db->bind(':password', $data['password']);
    $db->bind(':created', $data['created']);

    $db->cdp_execute();



    $recipient_id = $db->dbh->lastInsertId();

    $db->cdp_query("SELECT * FROM cdb_users where id= '" . $recipient_id . "'");
    $customer_data = $db->cdp_registro();




    $db->cdp_query("
                  INSERT INTO cdb_users_multiple_addresses 
                  (
                  address,
                  country,
                  city,
                  zip_code,
                  user_id                                
                  )
                  VALUES 
                  (
                  :address,
                  :country,
                  :city, 
                  :zip_code,
                  :user_id                            
                  )
                ");


    $db->bind(':user_id',  $recipient_id);
    $db->bind(':address',  cdp_sanitize($_POST["address_modal_user"]));
    $db->bind(':country',  cdp_sanitize($_POST["country_modal_user"]));
    $db->bind(':city',  cdp_sanitize($_POST["city_modal_user"]));
    $db->bind(':zip_code',  cdp_sanitize($_POST["postal_modal_user"]));

    $insert = $db->cdp_execute();

    $last_address_id = $db->dbh->lastInsertId();

    $db->cdp_query("SELECT * FROM cdb_users_multiple_addresses where id_addresses= '" . $last_address_id . "'");
    $customer_address = $db->cdp_registro();


    if ($insert) {

        $messages[] = "User added successfully!";
    } else {

        $errors['critical_error'] = "the registration was not completed";
    }
}


if (!empty($errors)) {
?>
   <div class="alert customize-alert alert-dismissible alert-light-danger text-danger fade show"
    role="alert" id="success-alert">
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
            <i data-feather="x" class="fill-white text-danger feather-sm"></i>
        </button>
        <div class="d-flex align-items-center font-medium me-3 me-md-0">
            <i class="bi-exclamation-diamond text-danger me-2"></i>
             <?php
            foreach ($errors as $error) { ?>
                    <?php
                    echo $error;

                    ?>
            <?php

            }
            ?>
        </div>

    </div>


<?php
}

if (isset($messages)) {

?>

     <div class="alert customize-alert alert-dismissible alert-light-info text-info fade show" role="alert" id="success-alert">
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        <div class="d-flex align-items-center font-medium">
            <p>
            <i class="bi-check2-all text-info me-2"></i>
             <?php
            foreach ($messages as $message) {
                echo $message;
            }
            ?>

            </p>
            <script>
            $("#add_user_from_modal_shipments")[0].reset();
        </script>
        </div>
    </div>



    <?php
    if ($_POST['type_user'] == 'user_recipient') { ?>

        <script>
            var data = {
                id: <?php echo $customer_data->id; ?>,
                text: "<?php echo $customer_data->fname . ' ' . $customer_data->lname; ?>"
            };


            var newOption = new Option(data.text, data.id, false, false);


            $('#recipient_id').append(newOption).trigger('change');
            $('#recipient_id').val(data.id).trigger('change');



            var data_address = {
                id: <?php echo $customer_address->id_addresses; ?>,
                text: "<?php echo $customer_address->address; ?>"
            };


            var newOption = new Option(data_address.text, data_address.id, false, false);

            $('#recipient_address_id').append(newOption).trigger('change');
            $('#recipient_address_id').val(data_address.id).trigger('change');
        </script>

    <?php }


    if ($_POST['type_user'] == 'user_customer') { ?>


        <script>
            var data = {
                id: <?php echo $customer_data->id; ?>,
                text: "<?php echo $customer_data->fname . ' ' . $customer_data->lname; ?>"
            };


            var newOption = new Option(data.text, data.id, false, false);


            $('#sender_id').append(newOption).trigger('change');
            $('#sender_id').val(data.id).trigger('change');



            var data_address = {
                id: <?php echo $customer_address->id_addresses; ?>,
                text: "<?php echo $customer_address->address; ?>"
            };


            var newOption = new Option(data_address.text, data_address.id, false, false);

            $('#sender_address_id').append(newOption).trigger('change');
            $('#sender_address_id').val(data_address.id).trigger('change');



            $("#recipient_address_id").attr("disabled", true);

            $("#add_address_recipient").attr("disabled", true);

            $("#recipient_id").val(null).trigger('change');
            $("#recipient_address_id").val(null).trigger('change');
        </script>

<?php
    }
}
?>