<?php
// *************************************************************************
// *                                                                       *
// * DEPRIXA BASIC -  Freight Forwarding & Shipping Software Solutions     *
// * Copyright (c) JAOMWEB. All Rights Reserved                            *
// *                                                                       *
// *************************************************************************
// *                                                                       *
// * Email: support@jaom.info                                              *
// * Website: https://deprixa.link/documentation/                          *
// *                                                                       *
// *************************************************************************
// *                                                                       *
// * This software is furnished under a license and may be used and copied *
// * only  in  accordance  with  the  terms  of such  license and with the *
// * inclusion of the above copyright notice.                              *
// * If you Purchased from Codecanyon, Please read the full License from   *
// * here- http://codecanyon.net/licenses/standard                         *
// *                                                                       *
// *************************************************************************



require_once("../../loader.php");
require_once("../../helpers/querys.php");

session_start();

$db = new Conexion;

$errors = array();

if (empty($_POST['id_shipment']))
    $errors['id_shipment'] = 'Please Enter shipment';


if (empty($_POST['driver_id']))
    $errors['driver_id'] = 'Please selected driver';



if (empty($errors)) {

    $data = array(
        'id_shipment' => trim($_POST['id_shipment']),
        'driver_id' => trim($_POST['driver_id']),
    );

    $insert = cdp_updateDriverCourier($data);

    if ($insert) {

        $messages[] = "Driver updated successfully!";


        // SAVE NOTIFICATION
        $db->cdp_query("
                                INSERT INTO cdb_notifications 
                                (
                                    user_id,
                                    order_id,
                                    notification_description,
                                    shipping_type,
                                    notification_date

                                )
                                VALUES
                                    (
                                    :user_id,                    
                                    :order_id,
                                    :notification_description,
                                    :shipping_type,
                                    :notification_date                    
                                    )
                            ");



        $db->bind(':user_id',  $_SESSION['userid']);
        $db->bind(':order_id',  $_POST['id_shipment']);
        $db->bind(':notification_description', 'a new driver has been assigned to the shipment, please check it');
        $db->bind(':shipping_type', '1');
        $db->bind(':notification_date',  date("Y-m-d H:i:s"));

        $db->cdp_execute();


        $notification_id = $db->dbh->lastInsertId();

        //NOTIFICATION TO DRIVER

        cdp_insertNotificationsUsers($notification_id, $_POST["driver_id"]);


        //NOTIFICATION TO ADMIN AND EMPLOYEES

        $users_employees = cdp_getUsersAdminEmployees();

        foreach ($users_employees as $key) {

            cdp_insertNotificationsUsers($notification_id, $key->id);
        }
        //NOTIFICATION TO CUSTOMER

        cdp_insertNotificationsUsers($notification_id, $_POST['id_senderclient_driver_update']);
    } else {

        $errors['critical_error'] = "the update was not completed";
    }
}


if (!empty($errors)) {
?>
    <div class="alert customize-alert alert-dismissible alert-light-danger text-danger fade show"
            role="alert" id="success-alert">
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
        <i data-feather="x" class="fill-white text-danger feather-sm"></i>
    </button>
    <div class="d-flex align-items-center font-medium me-3 me-md-0">
        <i class="bi-exclamation-diamond text-danger me-2"></i>
         <?php
        foreach ($errors as $error) { ?>
                <?php
                echo $error;

                ?>
        <?php

        }
        ?>
    </div>

</div>



<?php
}

if (isset($messages)) {

?>
    <div class="alert customize-alert alert-dismissible alert-light-info text-info fade show" role="alert" id="success-alert">
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        <div class="d-flex align-items-center font-medium">
            <p>
            <i class="bi-check2-all text-info me-2"></i>
             <?php
            foreach ($messages as $message) {
                echo $message;
            }
            ?>

            </p>

        </div>
    </div>


<?php
}
?>