<?php
// *************************************************************************
// *                                                                       *
// * DEPRIXA BASIC -  Freight Forwarding & Shipping Software Solutions     *
// * Copyright (c) JAOMWEB. All Rights Reserved                            *
// *                                                                       *
// *************************************************************************
// *                                                                       *
// * Email: support@jaom.info                                              *
// * Website: https://deprixa.link/documentation/                          *
// *                                                                       *
// *************************************************************************
// *                                                                       *
// * This software is furnished under a license and may be used and copied *
// * only  in  accordance  with  the  terms  of such  license and with the *
// * inclusion of the above copyright notice.                              *
// * If you Purchased from Codecanyon, Please read the full License from   *
// * here- http://codecanyon.net/licenses/standard                         *
// *                                                                       *
// *************************************************************************



require_once("../loader.php");
require_once("../helpers/querys.php");
require_once("../helpers/phpmailer/class.phpmailer.php");
require_once("../helpers/phpmailer/class.smtp.php");

$user = new User;
$core = new Core;
$db = new Conexion;


//Prefix tracking   
$sql = "SELECT * FROM cdb_settings";

$db->cdp_query($sql);

$db->cdp_execute();

$settings = $db->cdp_registro();

$order_prefix = $settings->prefix;
$siteemail = $settings->email_address;
$check_mail = $settings->mailer;
$names_info = $settings->smtp_names;
$mlogo = $settings->logo;
$msite_url = $settings->site_url;
$msnames = $settings->site_name;

//SMTP
$smtphoste = $settings->smtp_host;
$smtpuser = $settings->smtp_user;
$smtppass = $settings->smtp_password;
$smtpport = $settings->smtp_port;
$smtpsecure = $settings->smtp_secure;

//SMS TWILIO
$accountsid = $settings->twilio_sms_sid;
$authtoken = $settings->twilio_sms_token;
$twilionumbers = $settings->twilio_sms_number;

$errors = array();

if (empty($_POST['email']))

  $errors['email'] = 'Enter a valid email address';

if (!$user->cdp_emailExists($_POST['email']))

  $errors['email'] = 'The email address you entered does not exist.';

if (!$user->cdp_isValidEmail($_POST['email']))

  $errors['email'] = 'The email address you entered is invalid.';



if (empty($errors)) {


  $user_email = cdp_sanitize($_POST["email"]);

  $verify = cdp_verifyEmail($user_email);

  if ($verify) {
    //Generar pass aleatorio
    $possible = "2346789bcdfghjkmnpqrtvwxyzBCDFGHJKLMNPQRTVWXYZ";

    $maxlength = strlen($possible);

    $length = 8;

    $i = 0;

    $password = "";

    while ($i < $length) {
      // elige un caracter al azar de los posibles
      $char = substr($possible, mt_rand(0, $maxlength - 1), 1);

      //¿Ya hemos usado este carácter en $ contraseña?
      if (!strstr($password, $char)) {
        // no, así que está bien agregarlo al final de lo que ya tenemos ...
        $password .= $char;
        // . y aumentar el contador en uno
        $i++;
      }
    }

    $user_password = $password;

    $datos = [
      'password' => password_hash($user_password, PASSWORD_DEFAULT),
      'email' => $user_email
    ];

    $update = cdp_updatePassword($datos);

    $email_template = cdp_getEmailTemplates(2);

    $user_emailData = cdp_getUserForEmail($user_email);


    $body = str_replace(
      array(
        '[USERNAME]',
        '[PASSWORD]',
        '[URL]',
        '[LINK]',
        '[URL_LINK]',
        '[IP]',
        '[SITE_NAME]'
      ),
      array(
        $user_emailData->username,
        $user_password,
        $core->site_url,
        $core->site_url,
        $core->logo,
        $_SERVER['REMOTE_ADDR'],
        $core->site_name
      ),
      $email_template->body
    );

    $newbody = cdp_cleanOut($body);


        //SENDMAIL PHP
        if ($check_mail == 'PHP') {
            /*SIGUE RECOLECTANDO DATOS PARA FUNCION MAIL*/
            $message = $newbody;
            $websiteName = $names_info;
            $emailAddress = $smtpuser;
            $header = "MIME-Version: 1.0\r\n";
            $header .= "Content-type: text/html; charset=iso-8859-1\r\n";
            $header .= "From: " . $websiteName . " <" . $emailAddress . ">\r\n";
            $subject = $email_template->subject;
            mail($_POST['email'], $subject, $message, $header);
            /*FINALIZA RECOLECTANDO DATOS PARA FUNCION MAIL*/
            // var_dump($user_created_id);

        } elseif ($check_mail == 'SMTP') {
            //PHPMAILER PHP
            $destinatario = $user_email;

            $mail = new PHPMailer(true);            // Passing `true` enables exceptions

             //Server settings
          
            $mail->isSMTP();                        // Set mailer to use SMTP
            $mail->Host = $smtphoste;               // Specify main and backup SMTP servers
            $mail->SMTPAuth = true;                 // Enable SMTP authentication
            $mail->Username = $smtpuser;            // SMTP username
            $mail->Password = $smtppass;            // SMTP password
            $mail->SMTPSecure = 'tls';              // Enable TLS encryption, `ssl` also accepted
            $mail->Port = 587;                      // TCP port to connect to

            //Recipients
            $mail->setFrom(''.$smtpuser.'', $names_info);
            $mail->addAddress($destinatario);       // Add a recipient
            

            //Content
            $mail->isHTML(true); 
            $mail->CharSet = "utf-8";               // Set email format to HTML
            $mail->Subject = $email_template->subject;
            $mail->Body = "
                <html> 
                <body> 
                <p>{$newbody}</p>
                </body> 
                </html>
                <br />"; // Texto del email en formato HTML

            $mail->SMTPOptions = array(
                    'ssl' => array(
                        'verify_peer' => false,
                        'verify_peer_name' => false,
                        'allow_self_signed' => true
                    )
                );

            try {
                $mail->Send();
                //echo "El correo fue enviado correctamente.";
            } catch (Exception $e) {
                //echo "Ocurrió un error inesperado.";
            }
        } 



        $messages[] = "You have successfully changed your password. Please check your email for more information!";
      

       
    } else {

        $errors['critical_error'] = "An error occurred during the registration process. Contact the administrator ...";
    }
}



if (!empty($errors)) {
    // var_dump($errors);
?>


    <div class="alert alert-danger" role="alert" id="success-alert">
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
      <strong>Oh snap!</strong> <?php
            foreach ($errors as $error) { ?>
                    <?php
                     echo "".$error." <br> ";

                    ?>
            <?php

            }
            ?>
    </div>



<?php
}

if (isset($messages)) {

?>

    <div class="alert alert-success" role="alert" id="success-alert">
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
      <strong>Well done!</strong> <?php
            foreach ($messages as $message) {

                 echo "".$message." <br> ";
            }
            ?>
    </div>
<?php
}
?>