<?php
// *************************************************************************
// *                                                                       *
// * DEPRIXA BASIC -  Freight Forwarding & Shipping Software Solutions     *
// * Copyright (c) JAOMWEB. All Rights Reserved                            *
// *                                                                       *
// *************************************************************************
// *                                                                       *
// * Email: support@jaom.info                                              *
// * Website: https://deprixa.link/documentation/                          *
// *                                                                       *
// *************************************************************************
// *                                                                       *
// * This software is furnished under a license and may be used and copied *
// * only  in  accordance  with  the  terms  of such  license and with the *
// * inclusion of the above copyright notice.                              *
// * If you Purchased from Codecanyon, Please read the full License from   *
// * here- http://codecanyon.net/licenses/standard                         *
// *                                                                       *
// *************************************************************************



require_once("../../loader.php");

$db = new Conexion;
$user = new User;
$core = new Core;
$userData = $user->cdp_getUserData();

$status_courier = intval($_REQUEST['status_courier']);
$agency = intval($_REQUEST['agency']);
$range = cdp_sanitize($_REQUEST['range']);
$customer_id = intval($_REQUEST['customer_id']);


$sWhere = "";


if ($status_courier > 0) {

	$sWhere .= " and  a.status_courier = '" . $status_courier . "'";
}

if ($customer_id > 0) {

	$sWhere .= " and a.sender_id = '" . $customer_id . "'";
}


if ($agency > 0) {

	$sWhere .= " and a.agency = '" . $agency . "'";
}


if ($userData->userlevel == 3) {

	$sWhere .= " and  a.driver_id = '" . $_SESSION['userid'] . "'";
}

if (!empty($range)) {

	$fecha =  explode(" - ", $range);
	$fecha = str_replace('/', '-', $fecha);

	$fecha_inicio = date('Y-m-d', strtotime($fecha[0]));
	$fecha_fin = date('Y-m-d', strtotime($fecha[1]));


	$sWhere .= " and  a.order_date between '" . $fecha_inicio . "'  and '" . $fecha_fin . "'";
}

$sql = "SELECT a.total_declared_value, a.total_weight, a.total_tax_discount, a.sub_total, a.total_tax_insurance, a.total_tax_custom_tariffis, a.total_tax, a.total_fixed_value, a.status_invoice,  a.is_consolidate, a.is_pickup,  a.total_order, a.order_id, a.order_prefix, a.order_no, a.order_date, a.sender_id, a.receiver_id, a.order_courier,a.status_courier,  b.mod_style, b.color FROM
			 cdb_add_order as a

			 INNER JOIN cdb_styles as b ON a.status_courier = b.id
			 $sWhere
			  and a.status_courier!=14
			  and a.status_courier!=21 
			  and a.is_consolidate!=1

			 order by a.order_id desc 
			 ";


$query_count = $db->cdp_query($sql);
$db->cdp_execute();
$numrows = $db->cdp_rowCount();


$db->cdp_query($sql);
$data = $db->cdp_registros();


if ($numrows > 0) { ?>
	<div class="table-responsive">


		<table id="zero_config" class="table-sm table table-condensed table-hover table-striped custom-table-checkbox">
			<thead>
				<tr style="background-color: #3e5569; color: white">

					<th><b><?php echo $lang['ltracking'] ?></b></th>
					<th class="text-center"><b><?php echo $lang['ddate'] ?></b></th>
					<th class="text-center"><b><?php echo $lang['left332'] ?></b></th>
					<th class="text-center"><b><?php echo $lang['left473'] ?></b></th>
					<th class="text-center"><b><?php echo $lang['left464'] ?></b></th>
					<th class="text-center"><b><?php echo $lang['left463'] ?></b></th>
					<th class="text-center"><b><?php echo $lang['left499'] ?></b></th>
					<th class="text-center"><b><?php echo $lang['left473'] ?></b></th>
					<th class="text-center"><b><?php echo $lang['left464'] ?></b></th>
					<th class="text-center"><b><?php echo $lang['left463'] ?></b></th>
					<th class="text-center"><b><?php echo $lang['langs_044'] ?></b></th>
					<th class="text-center"><b><?php echo $lang['langs_08'] ?></b></th>
					<th class="text-center"><b><?php echo $lang['lstatusshipment'] ?></b></th>
				</tr>
			</thead>
			<tbody id="projects-tbl">


				<?php if (!$data) { ?>
					<tr>
						<td colspan="6">
							<?php echo "
				<i align='center' class='display-3 text-warning d-block'><img src='assets/images/alert/ohh_shipment.png' width='150' /></i>								
				", false; ?>
						</td>
					</tr>
				<?php } else { ?>

					<?php

					$count = 0;

					foreach ($data as $row) {

						$db->cdp_query("SELECT * FROM cdb_users where id= '" . $row->sender_id . "'");
						$sender_data = $db->cdp_registro();

						$db->cdp_query("SELECT * FROM cdb_users where id= '" . $row->receiver_id . "'");
						$receiver_data = $db->cdp_registro();

						$db->cdp_query("SELECT * FROM cdb_address_shipments where order_track='" . $row->order_prefix . $row->order_no . "'");
						$address_order = $db->cdp_registro();

						$db->cdp_query("SELECT * FROM cdb_add_order_item where order_id='" . $row->order_id . "'");
						$add_orderitem = $db->cdp_registro();

						$db->cdp_query("SELECT * FROM cdb_courier_com where id= '" . $row->order_courier . "'");
						$courier_com = $db->cdp_registro();


						$db->cdp_query("SELECT * FROM cdb_styles where id= '14'");
						$status_style_pickup = $db->cdp_registro();

						$db->cdp_query("SELECT * FROM cdb_styles where id= '13'");
						$status_style_consolidate = $db->cdp_registro();



						if ($row->status_invoice == 1) {

							$text_status = $lang['invoice_paid'];
							$label_class = "badge bg-light-success text-success fw-normal";
						} else if ($row->status_invoice == 2) {

							$text_status = $lang['invoice_pending'];
							$label_class = "badge bg-light-warning text-warning fw-normal";
						} else if ($row->status_invoice == 3) {
							$text_status = $lang['invoice_due'];
							$label_class = "badge bg-light-danger text-danger fw-normal";
						}



					?>


						<tr class="card-hover">

							<td><b><a href="courier_view.php?id=<?php echo $row->order_id; ?>"><?php echo $row->order_prefix . $row->order_no; ?></a></b></td>
							<td class="text-center">
								<?php echo $row->order_date; ?>
							</td>

							<td class="text-center">
								<?php echo $sender_data->fname; ?> <?php echo $sender_data->lname; ?>
							</td>

							<td class="text-center"><?php echo $address_order->sender_address; ?>-<?php echo $address_order->sender_city; ?></td>

							<td class="text-center">
								<?php echo $sender_data->phone; ?>
							</td>

							<td class="text-center">
								<?php echo $sender_data->email; ?>
							</td>


							<td class="text-center">
								<?php echo $receiver_data->fname; ?> <?php echo $receiver_data->lname; ?>
							</td>

							<td class="text-center"><?php echo $address_order->recipient_address; ?>-<?php echo $address_order->recipient_city; ?></td>

							<td class="text-center">
								<?php echo $receiver_data->phone; ?>
							</td>

							<td class="text-center">
								<?php echo $receiver_data->email; ?>
							</td>

							<td class="text-center">
								<?php echo $add_orderitem->order_item_quantity; ?>
							</td>

							<td class="text-center">
								<?php echo $add_orderitem->order_item_description; ?>
							</td>


							<td class="">

								<span style="background: <?php echo $row->color; ?>;" class="badge  fw-normal"><?php echo $row->mod_style; ?></span>
								<br>

								<?php
								if ($row->is_pickup == true) { ?>

									<span style="background: <?php echo $status_style_pickup->color; ?>;" class="badge  fw-normal"><?php echo $status_style_pickup->mod_style; ?></span>
								<?php
								}
								?>

								<?php
								if ($row->is_consolidate == true) { ?>

									<span style="background: <?php echo $status_style_consolidate->color; ?>;" class="badge  fw-normal"><?php echo $status_style_consolidate->mod_style; ?></span>
								<?php
								}
								?>
							</td>


						</tr>
					<?php $count++;
					} ?>

				<?php } ?>
			</tbody>

		</table>

	</div>
<?php } ?>