<?php
// *************************************************************************
// *                                                                       *
// * DEPRIXA BASIC -  Freight Forwarding & Shipping Software Solutions     *
// * Copyright (c) JAOMWEB. All Rights Reserved                            *
// *                                                                       *
// *************************************************************************
// *                                                                       *
// * Email: support@jaom.info                                              *
// * Website: https://deprixa.link/documentation/                          *
// *                                                                       *
// *************************************************************************
// *                                                                       *
// * This software is furnished under a license and may be used and copied *
// * only  in  accordance  with  the  terms  of such  license and with the *
// * inclusion of the above copyright notice.                              *
// * If you Purchased from Codecanyon, Please read the full License from   *
// * here- http://codecanyon.net/licenses/standard                         *
// *                                                                       *
// *************************************************************************



require_once("../../loader.php");

$db = new Conexion;
$user = new User;
$core = new Core;
$userData = $user->cdp_getUserData();

$range = cdp_sanitize($_REQUEST['range']);
$agency_courier = intval($_REQUEST['agency_courier']);
$pay_mode = intval($_REQUEST['pay_mode']);
$customer_id = intval($_REQUEST['customer_id']);

$sWhere = "";


if ($agency_courier > 0) {

	$sWhere .= " and agency = '" . $agency_courier . "'";
}


if ($customer_id > 0) {

	$sWhere .= " and sender_id = '" . $customer_id . "'";
}

if ($pay_mode > 0) {

	$sWhere .= " and order_payment_method = '" . $pay_mode . "'";
}
if (!empty($range)) {

	$fecha =  explode(" - ", $range);
	$fecha = str_replace('/', '-', $fecha);

	$fecha_inicio = date('Y-m-d', strtotime($fecha[0]));
	$fecha_fin = date('Y-m-d', strtotime($fecha[1]));


	$sWhere .= " and  order_date between '" . $fecha_inicio . "'  and '" . $fecha_fin . "' and status_courier!='21' and is_consolidate!=1";
}

$db->cdp_query("UPDATE cdb_add_order SET  status_invoice =3  WHERE due_date<now() and status_invoice !=1 and order_payment_method >1 ");


$db->cdp_execute();


$sql = "SELECT * FROM cdb_add_order where order_payment_method >1  
			
			$sWhere
			
			 order by order_id desc 
			 ";


$query_count = $db->cdp_query($sql);
$db->cdp_execute();
$numrows = $db->cdp_rowCount();


$db->cdp_query($sql);
$data = $db->cdp_registros();



if ($numrows > 0) { ?>
	<div class="table-responsive">


		<table id="zero_config" class="table table-condensed table-hover table-striped custom-table-checkbox">
			<thead>
				<tr style="background-color: #3e5569; color: white">
					<th><b><?php echo $lang['ltracking'] ?></b></th>
					<th class="text-center"><b><?php echo $lang['left332'] ?></b></th>
					<th class="text-center"><b><?php echo $lang['ddate'] ?></b></th>
					<th class="text-center"><b><?php echo $lang['leftorder109'] ?></b></th>
					<th class="text-center"><b><?php echo $lang['lstatusinvoice'] ?></b></th>
					<th class="text-center"><b><?php echo $lang['lstatusshipment'] ?></b></th>
					<th class="text-center"><b><?php echo $lang['left233'] ?></b></th>
					<th class="text-center"><b><?php echo $lang['leftorder110'] ?></b></th>
					<th class="text-center"><b><?php echo $lang['leftorder97'] ?></b></th>
				</tr>
			</thead>
			<tbody id="projects-tbl">


				<?php if (!$data) { ?>
					<tr>
						<td colspan="6">
							<?php echo "
				<i align='center' class='display-3 text-warning d-block'><img src='assets/images/alert/ohh_shipment.png' width='150' /></i>								
				", false; ?>
						</td>
					</tr>
				<?php } else { ?>

					<?php

					$count = 0;
					$sumador_pendiente = 0;
					$sumador_total = 0;
					$sumador_pagado = 0;

					foreach ($data as $row) {

						$db->cdp_query("SELECT * FROM cdb_users where id= '" . $row->sender_id . "'");
						$sender_data = $db->cdp_registro();

						$db->cdp_query("SELECT * FROM cdb_users where id= '" . $row->receiver_id . "'");
						$receiver_data = $db->cdp_registro();

						$db->cdp_query("SELECT * FROM cdb_users where id= '" . $row->driver_id . "'");
						$driver_data = $db->cdp_registro();


						$db->cdp_query("SELECT * FROM cdb_styles where id= '14'");
						$status_style_pickup = $db->cdp_registro();

						$db->cdp_query("SELECT * FROM cdb_styles where id= '13'");
						$status_style_consolidate = $db->cdp_registro();


						$db->cdp_query("SELECT * FROM cdb_styles where id= '".$row->status_courier."'");
						$status_style = $db->cdp_registro();


						$db->cdp_query('SELECT  IFNULL(sum(total), 0)  as total  FROM cdb_charges_order WHERE order_id=:order_id');

						$db->bind(':order_id', $row->order_id);

						$db->cdp_execute();

						$sum_payment = $db->cdp_registro();
						// var_dump($sum_payment->total);

						$pendiente = $row->total_order - $sum_payment->total;


						if ($row->status_invoice == 1) {

							$text_status = $lang['invoice_paid'];
							$label_class = "badge bg-light-success text-success fw-normal";
						} else if ($row->status_invoice == 2) {

							$text_status = $lang['invoice_pending'];
							$label_class = "badge bg-light-warning text-warning fw-normal";
						} else if ($row->status_invoice == 3) {
							$text_status = $lang['invoice_due'];
							$label_class = "badge bg-light-danger text-danger fw-normal";
						}

						$sumador_pendiente += $pendiente;
						$sumador_total += $row->total_order;
						$sumador_pagado += $sum_payment->total;


					?>
						<tr class="card-hovera">

							<td><b><a data-toggle="modal" data-target="#charges_list" data-id="<?php echo $row->order_id; ?>"><?php echo $row->order_prefix . $row->order_no; ?></a></b></td>

							<td class="text-center">
								<?php echo $sender_data->fname; ?> <?php echo $sender_data->lname; ?>
							</td>

							<td class="text-center">
								<?php echo $row->order_date; ?>
							</td>

							<td class="text-center">
								<?php echo $row->due_date; ?>
							</td>

							<td class="text-center">
								<span class="<?php echo $label_class; ?>"><?php echo $text_status; ?></span>

							</td>

							<td class="text-center">

								<span style="background: <?php echo $status_style->color; ?>;" class="badge  fw-normal"><?php echo $status_style->mod_style; ?></span>
								<br>

								<?php
								if ($row->is_pickup == true) { ?>

									<span style="background: <?php echo $status_style_pickup->color; ?>;" class="badge  fw-normal"><?php echo $status_style_pickup->mod_style; ?></span>
								<?php
								}
								?>

								<?php
								if ($row->is_consolidate == true) { ?>

									<span style="background: <?php echo $status_style_consolidate->color; ?>;" class="badge  fw-normal"><?php echo $status_style_consolidate->mod_style; ?></span>
								<?php
								}
								?>
							</td>

							<td class="text-center">
								<b><?php echo $core->currency; ?></b> <?php echo number_format($row->total_order, 2, '.', ''); ?>
							</td>

							<td class="text-center">
								<b><?php echo $core->currency; ?></b> <?php echo number_format($sum_payment->total, 2, '.', ''); ?>
							</td>

							<td class="text-center">
								<b><?php echo $core->currency; ?></b> <?php echo number_format($pendiente, 2, '.', ''); ?>
							</td>

						</tr>
					<?php $count++;
					} ?>

				<?php } ?>
			</tbody>
			<tfoot>
				<tr class="card-hover">
					<td class="text-left"><b>TOTAL</b></td>

					<td colspan="5"></td>
					<td class="text-center  ">
						<b><?php echo number_format($sumador_total, 2, '.', ''); ?> </b>
					</td>

					<td class="text-center  ">
						<b><?php echo number_format($sumador_pagado, 2, '.', ''); ?> </b>
					</td>

					<td class="text-center  ">
						<b><?php echo number_format($sumador_pendiente, 2, '.', ''); ?> </b>
					</td>

				</tr>

			</tfoot>

		</table>

	</div>
<?php } ?>