<?php
// *************************************************************************
// *                                                                       *
// * DEPRIXA BASIC -  Freight Forwarding & Shipping Software Solutions     *
// * Copyright (c) JAOMWEB. All Rights Reserved                            *
// *                                                                       *
// *************************************************************************
// *                                                                       *
// * Email: support@jaom.info                                              *
// * Website: https://deprixa.link/documentation/                          *
// *                                                                       *
// *************************************************************************
// *                                                                       *
// * This software is furnished under a license and may be used and copied *
// * only  in  accordance  with  the  terms  of such  license and with the *
// * inclusion of the above copyright notice.                              *
// * If you Purchased from Codecanyon, Please read the full License from   *
// * here- http://codecanyon.net/licenses/standard                         *
// *                                                                       *
// *************************************************************************



require_once("../loader.php");
require_once("../helpers/querys.php");
require_once("../helpers/phpmailer/class.phpmailer.php");
require_once("../helpers/phpmailer/class.smtp.php");

$user = new User;
$core = new Core;
$db = new Conexion;


//Prefix tracking   
$sql = "SELECT * FROM cdb_settings";

$db->cdp_query($sql);

$db->cdp_execute();

$settings = $db->cdp_registro();

$order_prefix = $settings->prefix;
$siteemail = $settings->email_address;
$check_mail = $settings->mailer;
$names_info = $settings->smtp_names;
$mlogo = $settings->logo;
$msite_url = $settings->site_url;
$msnames = $settings->site_name;

//SMTP
$smtphoste = $settings->smtp_host;
$smtpuser = $settings->smtp_user;
$smtppass = $settings->smtp_password;
$smtpport = $settings->smtp_port;
$smtpsecure = $settings->smtp_secure;

//SMS TWILIO
$accountsid = $settings->twilio_sms_sid;
$authtoken = $settings->twilio_sms_token;
$twilionumbers = $settings->twilio_sms_number;

$errors = array();

if (empty($_POST['username']))

    $errors['username'] = 'Enter a valid username';

if ($value = $user->cdp_usernameExists($_POST['username']))

    if ($value == 1)

        $errors['username'] = 'Username is too short (less than 4 characters long).';

if ($value == 2)

    $errors['username'] = 'Invalid characters found in the username.';

if ($value == 3)
    $errors['username'] = 'Sorry, this username is already taken';



if (empty($_POST['fname']))

    $errors['fname'] = 'Please enter the name';
if (empty($_POST['lname']))

    $errors['lname'] = 'Please enter the last name';

if (empty($_POST['pass']))

    $errors['password'] = 'Enter a valid password.';

if (strlen($_POST['pass']) < 6)

    $errors['password'] = 'Password is too short (less than 6 characters)';

if ($_POST['pass'] != $_POST['pass2'])

    $errors['password'] = 'Your password does not match the confirmed password!.';

if (empty($_POST['email']))

    $errors['email'] = 'Enter a valid email address';

if ($user->cdp_emailExists($_POST['email']))

    $errors['email'] = 'The email address you entered is already in use.';

if (!$user->cdp_isValidEmail($_POST['email']))

    $errors['email'] = 'The email address you entered is invalid.';

if (empty($_POST['address']))

    $errors['address'] = 'Please enter the address';

if (empty($_POST['terms']))

    $errors['terms'] = 'Please accept the terms and conditions';

if (empty($_POST['phone']))

    $errors['phone'] = 'Please enter the phone';

if (empty($errors)) {


    if ($core->auto_verify == 1) {
          $active = "1";
      } elseif ($core->auto_verify == 0) {
          $active = "0";
      }

    $datos = array(
        'username' => cdp_sanitize($_POST['username']), 
        'email' => cdp_sanitize($_POST['email']), 
        'lname' => cdp_sanitize($_POST['lname']),
        'fname' => cdp_sanitize($_POST['fname']),
        'locker' => cdp_sanitize($_POST['locker']),
        'country' => cdp_sanitize($_POST['country']),
        'city' => cdp_sanitize($_POST['city']),
        'phone' => cdp_sanitize($_POST['phone']),
        'address' => cdp_sanitize($_POST['address']),
        'active' => $active, 
        'userlevel' => 1,
    );

    if ($_POST['pass'] != "") {

        $datos['password'] = password_hash($_POST['pass'], PASSWORD_DEFAULT);
    }

    if (isset($_POST['terms'])) {
        $datos['terms'] = $_POST['terms'];
    } else {
        $datos['terms'] = "";
    }



    $datos['created'] = date("Y-m-d H:i:s");




    $db->cdp_query('INSERT INTO cdb_users
        (
            username,
            password,
            locker,
            userlevel,
            email,
            fname,
            lname,
            phone,
            created,
            active,
            terms
            
        )

        VALUES (
            :username,
            :password,
            :locker,
            :userlevel,
            :email,
            :fname,
            :lname,
            :phone,
            :created,
            :active,
            :terms
        )');


    $db->bind(':username', $datos['username']);
    $db->bind(':password', $datos['password']);
    $db->bind(':userlevel', $datos['userlevel']);
    $db->bind(':email', $datos['email']);
    $db->bind(':fname', $datos['fname']);
    $db->bind(':lname', $datos['lname']);
    $db->bind(':phone', $datos['phone']);
    $db->bind(':created', $datos['created']);
    $db->bind(':active', $datos['active']);
    $db->bind(':locker', $datos['locker']);
    $db->bind(':terms', $datos['terms']);



    $insert = $db->cdp_execute();

    $user_created_id = $db->dbh->lastInsertId();


    $db->cdp_query("
          INSERT INTO cdb_users_multiple_addresses 
          (
          address,
          country,
          city,
          user_id                                
          )
          VALUES 
          (
          :address,
          :country,
          :city, 
          :user_id                            
          )
        ");


    $db->bind(':user_id',  $user_created_id);
    $db->bind(':address',  cdp_sanitize($_POST["address"]));
    $db->bind(':country',  cdp_sanitize($_POST["country"]));
    $db->bind(':city',  cdp_sanitize($_POST["city"]));

    $db->cdp_execute();


    if ($insert) {

        $db->cdp_query("
                INSERT INTO cdb_notifications 
                (
                    user_id,
                    notification_description,
                    shipping_type,
                    notification_date

                )
                VALUES
                    (
                    :user_id,                    
                    :notification_description,
                    :shipping_type,
                    :notification_date                    
                    )
              ");



        $db->bind(':user_id',  $user_created_id);
        $db->bind(':notification_description', 'a new user has been registered');
        $db->bind(':shipping_type', '0');
        $db->bind(':notification_date',  date("Y-m-d H:i:s"));

        $db->cdp_execute();

        $notification_id = $db->dbh->lastInsertId();


        //NOTIFICATION TO ADMIN AND EMPLOYEES

        $users_employees = cdp_getUsersAdminEmployees();

        foreach ($users_employees as $key) {

            cdp_insertNotificationsUsers($notification_id, $key->id);
        }


        if ($core->auto_verify == 0) {

         $email_template = cdp_getEmailTemplates(27);
          
          $body = str_replace(
              array(
                  '[NAME]',
                  '[USERNAME]',
                  '[PASSWORD]',
                  '[LOCKER]',
                  '[URL]',
                  '[URL_LINK]',
                  '[SITE_NAME]'
                ), 

              array(
                  $_POST['fname'] . ' ' . $_POST['lname'],
                  $_POST['username'],
                  $_POST['pass'],
                  $_POST['locker'],
                  $core->site_url,
                  $core->logo,
                  $core->site_name

                    ), 
                    $email_template->body
                );

                $newbody = cdp_cleanOut($body); 

                 //SENDMAIL PHP
                if ($check_mail == 'PHP') {
                    /*SIGUE RECOLECTANDO DATOS PARA FUNCION MAIL*/
                    $message = $newbody;
                    $websiteName = $names_info;
                    $emailAddress = $smtpuser;
                    $header = "MIME-Version: 1.0\r\n";
                    $header .= "Content-type: text/html; charset=iso-8859-1\r\n";
                    $header .= "From: " . $websiteName . " <" . $emailAddress . ">\r\n";
                    $subject = $email_template->subject;
                    mail($_POST['email'], $subject, $message, $header);
                    /*FINALIZA RECOLECTANDO DATOS PARA FUNCION MAIL*/
                    // var_dump($user_created_id);

                } elseif ($check_mail == 'SMTP') {
                    //PHPMAILER PHP
                    $destinatario = "" . $_POST['email'] . "";


                    $mail = new PHPMailer(true);            // Passing `true` enables exceptions
      
                     //Server settings
                  
                    $mail->isSMTP();                        // Set mailer to use SMTP
                    $mail->Host = $smtphoste;               // Specify main and backup SMTP servers
                    $mail->SMTPAuth = true;                 // Enable SMTP authentication
                    $mail->Username = $smtpuser;            // SMTP username
                    $mail->Password = $smtppass;            // SMTP password
                    $mail->SMTPSecure = 'tls';              // Enable TLS encryption, `ssl` also accepted
                    $mail->Port = 587;                      // TCP port to connect to

                    //Recipients
                    $mail->setFrom(''.$smtpuser.'', $names_info);
                    $mail->addAddress($destinatario);       // Add a recipient
                    

                    //Content
                    $mail->isHTML(true); 
                    $mail->CharSet = "utf-8";               // Set email format to HTML
                    $mail->Subject = $email_template->subject;
                    $mail->Body = "
                        <html> 
                        <body> 
                        <p>{$newbody}</p>
                        </body> 
                        </html>
                        <br />"; // Texto del email en formato HTML

                    $mail->SMTPOptions = array(
                            'ssl' => array(
                                'verify_peer' => false,
                                'verify_peer_name' => false,
                                'allow_self_signed' => true
                            )
                        );

                    try {
                        $mail->Send();
                        //echo "El correo fue enviado correctamente.";
                    } catch (Exception $e) {
                        //echo "Ocurrió un error inesperado.";
                    }
                }  

                $messages[] = "You registered successfully, check your email with the access data, but the administrator must activate your account.";  
          
      } else {

          $email_template = cdp_getEmailTemplates(7);

            $body = str_replace(
                array(
                    '[NAME]',
                    '[USERNAME]',
                    '[PASSWORD]',
                    '[LOCKER]',
                    '[VIRTUAL_LOCKER]',
                    '[CCOUNTRY]',
                    '[CCITY]',
                    '[CPOSTAL]',
                    '[CPHONE]',
                    '[EMAIL]',
                    '[URL]',
                    '[URL_LINK]',
                    '[SITE_NAME]'
                ),
                array(
                    $_POST['fname'] . ' ' . $_POST['lname'],
                    $_POST['username'],
                    $_POST['pass'],
                    $_POST['locker'],
                    $core->locker_address,
                    $core->c_country,
                    $core->c_city,
                    $core->c_postal,
                    $core->c_phone,
                    $_POST['email'],
                    $core->site_url,
                    $core->logo,
                    $core->site_name
                ),
                $email_template->body
            );

                $newbody = cdp_cleanOut($body);


                 //SENDMAIL PHP
                if ($check_mail == 'PHP') {
                    /*SIGUE RECOLECTANDO DATOS PARA FUNCION MAIL*/
                    $message = $newbody;
                    $websiteName = $names_info;
                    $emailAddress = $smtpuser;
                    $header = "MIME-Version: 1.0\r\n";
                    $header .= "Content-type: text/html; charset=iso-8859-1\r\n";
                    $header .= "From: " . $websiteName . " <" . $emailAddress . ">\r\n";
                    $subject = $email_template->subject;
                    mail($_POST['email'], $subject, $message, $header);
                    /*FINALIZA RECOLECTANDO DATOS PARA FUNCION MAIL*/
                    // var_dump($user_created_id);

                } elseif ($check_mail == 'SMTP') {
                    //PHPMAILER PHP
                    $destinatario = "" . $_POST['email'] . "";


                    $mail = new PHPMailer(true);            // Passing `true` enables exceptions
      
                     //Server settings
                  
                    $mail->isSMTP();                        // Set mailer to use SMTP
                    $mail->Host = $smtphoste;               // Specify main and backup SMTP servers
                    $mail->SMTPAuth = true;                 // Enable SMTP authentication
                    $mail->Username = $smtpuser;            // SMTP username
                    $mail->Password = $smtppass;            // SMTP password
                    $mail->SMTPSecure = 'tls';              // Enable TLS encryption, `ssl` also accepted
                    $mail->Port = 587;                      // TCP port to connect to

                    //Recipients
                    $mail->setFrom(''.$smtpuser.'', $names_info);
                    $mail->addAddress($destinatario);       // Add a recipient
                    

                    //Content
                    $mail->isHTML(true); 
                    $mail->CharSet = "utf-8";               // Set email format to HTML
                    $mail->Subject = $email_template->subject;
                    $mail->Body = "
                        <html> 
                        <body> 
                        <p>{$newbody}</p>
                        </body> 
                        </html>
                        <br />"; // Texto del email en formato HTML

                    $mail->SMTPOptions = array(
                            'ssl' => array(
                                'verify_peer' => false,
                                'verify_peer_name' => false,
                                'allow_self_signed' => true
                            )
                        );

                    try {
                        $mail->Send();
                        //echo "El correo fue enviado correctamente.";
                    } catch (Exception $e) {
                        //echo "Ocurrió un error inesperado.";
                    }
                } 

                $messages[] = "You have successfully registered. Please check your email for further information.";


      } if ($core->notify_admin == 1) {
          $email_template = cdp_getEmailTemplates(13);

          $body = str_replace(array(
              '[USERNAME]',
              '[EMAIL]', 
              '[LOCKER]',
              '[NAME]',
              '[IP]'
            ), 
          array(
              $_POST['username'],
              $_POST['email'],
              $_POST['locker'],
              $_POST['fname'] . ' ' . $_POST['lname'],
              $_SERVER['REMOTE_ADDR']
            ), 
            $email_template->body
        );

            $newbody = cdp_cleanOut($body);


        //SENDMAIL PHP
        if ($check_mail == 'PHP') {
            /*SIGUE RECOLECTANDO DATOS PARA FUNCION MAIL*/
            $message = $newbody;
            $websiteName = $names_info;
            $emailAddress = $csmtpuser;
            $header = "MIME-Version: 1.0\r\n";
            $header .= "Content-type: text/html; charset=iso-8859-1\r\n";
            $header .= "From: " . $websiteName . " <" . $emailAddress . ">\r\n";
            $header .= "Bcc: " . $siteemail . "\r\n";
            $subject = $email_template->subject;
            mail($_POST['email'], $subject, $message, $header);
            /*FINALIZA RECOLECTANDO DATOS PARA FUNCION MAIL*/
            // var_dump($user_created_id);

        } elseif ($check_mail == 'SMTP') {
            //PHPMAILER PHP
            $destinatario = "" . $_POST['email'] . "";


            $mail = new PHPMailer(true);            // Passing `true` enables exceptions

             //Server settings
          
            $mail->isSMTP();                        // Set mailer to use SMTP
            $mail->Host = $smtphoste;               // Specify main and backup SMTP servers
            $mail->SMTPAuth = true;                 // Enable SMTP authentication
            $mail->Username = $smtpuser;            // SMTP username
            $mail->Password = $smtppass;            // SMTP password
            $mail->SMTPSecure = 'tls';              // Enable TLS encryption, `ssl` also accepted
            $mail->Port = 587;                      // TCP port to connect to

            //Recipients
            $mail->setFrom(''.$smtpuser.'', $names_info);
            $mail->addAddress($destinatario);       // Add a recipient
            //CC Copia al admin
            $mail->addCC(''.$siteemail.'');
            

            //Content
            $mail->isHTML(true); 
            $mail->CharSet = "utf-8";               // Set email format to HTML
            $mail->Subject = $email_template->subject;
            $mail->Body = "
                <html> 
                <body> 
                <p>{$newbody}</p>
                </body> 
                </html>
                <br />"; // Texto del email en formato HTML

            $mail->SMTPOptions = array(
                    'ssl' => array(
                        'verify_peer' => false,
                        'verify_peer_name' => false,
                        'allow_self_signed' => true
                    )
                );

            try {
                $mail->Send();
                //echo "El correo fue enviado correctamente.";
            } catch (Exception $e) {
                //echo "Ocurrió un error inesperado.";
            }
        } 

      }

        


    } else {

        $errors['critical_error'] = "An error occurred during the registration process. Contact the administrator ...";
    }

         
      


}


if (!empty($errors)) {
    // var_dump($errors);
?>


    <div class="alert alert-danger" role="alert" id="success-alert">
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
      <strong>Oh snap!</strong> <?php
            foreach ($errors as $error) { ?>
                    <?php
                     echo "".$error." <br> ";

                    ?>
            <?php

            }
            ?>
    </div>



<?php
}

if (isset($messages)) {

?>

    <div class="alert alert-success" role="alert" id="success-alert">
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
      <strong>Well done!</strong> <?php
            foreach ($messages as $message) {

                 echo "".$message." <br> ";
            }
            ?>
    </div>
<?php
}
?>