<?php
// *************************************************************************
// *                                                                       *
// * DEPRIXA BASIC -  Freight Forwarding & Shipping Software Solutions     *
// * Copyright (c) JAOMWEB. All Rights Reserved                            *
// *                                                                       *
// *************************************************************************
// *                                                                       *
// * Email: support@jaom.info                                              *
// * Website: https://deprixa.link/documentation/                          *
// *                                                                       *
// *************************************************************************
// *                                                                       *
// * This software is furnished under a license and may be used and copied *
// * only  in  accordance  with  the  terms  of such  license and with the *
// * inclusion of the above copyright notice.                              *
// * If you Purchased from Codecanyon, Please read the full License from   *
// * here- http://codecanyon.net/licenses/standard                         *
// *                                                                       *
// *************************************************************************



require_once("../../loader.php");
require_once("../../helpers/querys.php");

$errors = array();

if (empty($_POST['longitude']))

    $errors['longitude'] = "Please enter account longitude!";

if (empty($_POST['latitude']))

    $errors['latitude'] = "Please enter latitude!";

if (empty($_POST['apikey']))

    $errors['apikey'] = "Please enter apikey!";



if (empty($errors)) {

    $data = array(
        'longitude' => cdp_sanitize($_POST['longitude']),
        'latitude' => cdp_sanitize($_POST['latitude']),
        'apikey' => cdp_sanitize($_POST['apikey'])
    );

    $insert = cdp_updateConfigApiGoogle($data);

    if ($insert) {

        $messages[] = "Configuration updated successfully!";
    } else {

        $errors['critical_error'] = "the update was not completed";
    }
}


if (!empty($errors)) {
?>
     <div class="alert customize-alert alert-dismissible alert-light-danger text-danger fade show"
            role="alert" id="success-alert">
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
            <i data-feather="x" class="fill-white text-danger feather-sm"></i>
        </button>
        <div class="d-flex align-items-center font-medium me-3 me-md-0">
            <i class="bi-exclamation-diamond text-danger me-2"></i>
             <?php
            foreach ($errors as $error) { ?>

                    <?php
                    echo " -> ". "".$error."". " </br> ";

                    ?>

            <?php

            }
            ?>
        </div>

    </div>



<?php
}

if (isset($messages)) {

?>
    <div class="alert alert-info" id="success-alert">
        <p><span class="icon-info-sign"></span><i class="close icon-remove-circle"></i>
            <?php
            foreach ($messages as $message) {
                echo $message;
            }
            ?>
        </p>
    </div>

<?php
}
?>