<?php
// *************************************************************************
// *                                                                       *
// * DEPRIXA BASIC -  Freight Forwarding & Shipping Software Solutions     *
// * Copyright (c) JAOMWEB. All Rights Reserved                            *
// *                                                                       *
// *************************************************************************
// *                                                                       *
// * Email: support@jaom.info                                              *
// * Website: https://deprixa.link/documentation/                          *
// *                                                                       *
// *************************************************************************
// *                                                                       *
// * This software is furnished under a license and may be used and copied *
// * only  in  accordance  with  the  terms  of such  license and with the *
// * inclusion of the above copyright notice.                              *
// * If you Purchased from Codecanyon, Please read the full License from   *
// * here- http://codecanyon.net/licenses/standard                         *
// *                                                                       *
// *************************************************************************



require_once("../../../loader.php");
require_once("../../../helpers/querys.php");

$errors = array();

if (empty($_POST['name_pack']))
    $errors['name_pack'] = 'Please Enter New Packaging Type';

if (cdp_packExists($_POST['name_pack']))
    $errors['name_pack'] = 'The new Packaging Type is already in use.. <b>"' . $_POST['name_pack'] . '"</b>';

if (empty($_POST['detail_pack']))
    $errors['detail_pack'] = 'Please Enter New Details Packaging Type';


if (empty($errors)) {

    $data = array(
        'name_pack' => cdp_sanitize($_POST['name_pack']),
        'detail_pack' => cdp_sanitize($_POST['detail_pack'])
    );

    $insert = cdp_insertPackaging($data);

    if ($insert) {

        $messages[] = "New Packaging Type added successfully!";
    } else {

        $errors['critical_error'] = "the insert was not completed";
    }
}


if (!empty($errors)) {
?>
   <div class="alert customize-alert alert-dismissible alert-light-danger text-danger fade show"
            role="alert" id="success-alert">
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
            <i data-feather="x" class="fill-white text-danger feather-sm"></i>
        </button>
        <div class="d-flex align-items-center font-medium me-3 me-md-0">
            <i class="bi-exclamation-diamond text-danger me-2"></i>
             <?php
            foreach ($errors as $error) { ?>

                    <?php
                    echo " -> ". "".$error."". " </br> ";

                    ?>

            <?php

            }
            ?>
        </div>

    </div>



<?php
}

if (isset($messages)) {

?>
   <div class="alert customize-alert alert-dismissible alert-light-info text-info fade show" role="alert" id="success-alert">
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        <div class="d-flex align-items-center font-medium">
            <p>
            <i class="bi-check2-all text-info me-2"></i>
             <?php
            foreach ($messages as $message) {
                echo $message;
            }
            ?>

            </p>

        </div>
    </div>

<?php
}
?>