<?php
// *************************************************************************
// *                                                                       *
// * DEPRIXA BASIC -  Freight Forwarding & Shipping Software Solutions     *
// * Copyright (c) JAOMWEB. All Rights Reserved                            *
// *                                                                       *
// *************************************************************************
// *                                                                       *
// * Email: support@jaom.info                                              *
// * Website: https://deprixa.link/documentation/                          *
// *                                                                       *
// *************************************************************************
// *                                                                       *
// * This software is furnished under a license and may be used and copied *
// * only  in  accordance  with  the  terms  of such  license and with the *
// * inclusion of the above copyright notice.                              *
// * If you Purchased from Codecanyon, Please read the full License from   *
// * here- http://codecanyon.net/licenses/standard                         *
// *                                                                       *
// *************************************************************************



require_once("../../../loader.php");

$db = new Conexion;


$search = cdp_sanitize($_REQUEST['search']);

$tables = "cdb_payment_methods";
$fields = "*";

$sWhere = "";


$sWhere .= " label LIKE '%" . $search . "%'";


$sWhere .= " order by label desc";

// // pagination variables
$page = (isset($_REQUEST['page']) && !empty($_REQUEST['page'])) ? $_REQUEST['page'] : 1;
$per_page = 10; //how much records you want to show
$adjacents  = 4; //gap between pages after number of adjacents
$offset = ($page - 1) * $per_page;

$sql = "SELECT $fields FROM  $tables where $sWhere";
$query_count = $db->cdp_query($sql);
$db->cdp_execute();
$numrows = $db->cdp_rowCount();


$db->cdp_query($sql . " limit $offset, $per_page");
$data = $db->cdp_registros();

$total_pages = ceil($numrows / $per_page);


if ($numrows > 0) { ?>


	<table id="zero_config" class="table table-condensed table-hover table-striped" data-pagination="true" data-page-size="5">
		<thead>
			<tr>
				<th data-sort-initial="true" data-bs-toggle="true"><b><?php echo $lang['tools-methodpay12'] ?></b></th>
				<!-- <th data-hide="Description"><b><?php echo $lang['tools-methodpay13'] ?></b></th> -->
				<th data-sort-ignore="true"><b><?php echo $lang['leftorder104'] ?></b></th>
				<th data-sort-ignore="true" class="text-center"><?php echo $lang['aaction'] ?></th>
			</tr>
		</thead>


		<?php if (!$data) { ?>
			<tr>
				<td colspan="3">
					<?php echo "
				<i align='center' class='display-3 text-warning d-block'><img src='assets/images/alert/ohh_shipment.png' width='150' /></i>								
				", false; ?>
				</td>
			</tr>
		<?php } else { ?>
			<?php foreach ($data as $row) { ?>
				<tr>
					<td><?php echo $row->label; ?></td>
					<td><?php echo $row->days; ?></td>

					<td class="text-center">
						<?php
						if ($row->id != 1) {

						?>
							<a href="payment_methods_edit.php?id=<?php echo $row->id; ?>" data-bs-toggle="tooltip" data-original-title="<?php echo $lang['tools-methodpay16'] ?>"><i class="bi-eye"></i></a>
							<a id="item_<?php echo $row->id; ?>" onclick="cdp_eliminar('<?php echo $row->id; ?>');" class="delete" data-rel="<?php echo $row->label; ?>" data-bs-toggle="tooltip" data-original-title="<?php echo $lang['tools-methodpay17'] ?>"><i class="bi-eraser"></i></a>
						<?php } ?>
					</td>

				</tr>
			<?php } ?>

		<?php } ?>

	</table>


	<div class="pull-right">
		<?php echo cdp_paginate($page, $total_pages, $adjacents);	?>
	</div>
	</div>
<?php } ?>