<?php
// *************************************************************************
// *                                                                       *
// * DEPRIXA BASIC -  Freight Forwarding & Shipping Software Solutions     *
// * Copyright (c) JAOMWEB. All Rights Reserved                            *
// *                                                                       *
// *************************************************************************
// *                                                                       *
// * Email: support@jaom.info                                              *
// * Website: https://deprixa.link/documentation/                          *
// *                                                                       *
// *************************************************************************
// *                                                                       *
// * This software is furnished under a license and may be used and copied *
// * only  in  accordance  with  the  terms  of such  license and with the *
// * inclusion of the above copyright notice.                              *
// * If you Purchased from Codecanyon, Please read the full License from   *
// * here- http://codecanyon.net/licenses/standard                         *
// *                                                                       *
// *************************************************************************



require_once("../../loader.php");
require_once("../../helpers/querys.php");

$errors = array();

if (empty($_POST['twilio_sid']))
    $errors['twilio_sid'] = 'Please Enter twilio ACCOUNT SID';

if (empty($_POST['twilio_token']))
    $errors['twilio_token'] = 'Please Enter twilio AUTH TOKEN';

if (empty($_POST['twilio_number']))
    $errors['twilio_number'] = 'Please Enter twilio NUMBER';

if (empty($errors)) {

    $data = array(
        'twilio_sid' => cdp_sanitize($_POST['twilio_sid']),
        'twilio_token' => cdp_sanitize($_POST['twilio_token']),
        'twilio_number' => cdp_sanitize($_POST['twilio_number']),
    );

    $insert = cdp_updateTwilioConfig($data);

    if ($insert) {

        $messages[] = "Twilio settings updated successfully!";
    } else {

        $errors['critical_error'] = "the insert was not completed";
    }
}


if (!empty($errors)) {
?>
  <div class="alert customize-alert alert-dismissible alert-light-danger text-danger fade show"
            role="alert" id="success-alert">
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
            <i data-feather="x" class="fill-white text-danger feather-sm"></i>
        </button>
        <div class="d-flex align-items-center font-medium me-3 me-md-0">
            <i class="bi-exclamation-diamond text-danger me-2"></i>
             <?php
            foreach ($errors as $error) { ?>

                    <?php
                    echo " -> ". "".$error."". " </br> ";

                    ?>

            <?php

            }
            ?>
        </div>

    </div>



<?php
}

if (isset($messages)) {

?>
   <div class="alert customize-alert alert-dismissible alert-light-info text-info fade show" role="alert" id="success-alert">
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        <div class="d-flex align-items-center font-medium">
            <p>
            <i class="bi-check2-all text-info me-2"></i>
             <?php
            foreach ($messages as $message) {
                echo $message;
            }
            ?>

            </p>

        </div>
    </div>

<?php
}
?>