$(function() {
    "use strict";

    // Feather Icon Init Js
    feather.replace();

    $(".preloader").fadeOut();
    // ==============================================================
    // Theme options
    // ==============================================================
    // ==============================================================
    // sidebar-hover
    // ==============================================================

    $(".left-sidebar").hover(
        function() {
            $(".navbar-header").addClass("expand-logo");
        },
        function() {
            $(".navbar-header").removeClass("expand-logo");
        }
    );
    // this is for close icon when navigation open in mobile view
    $(".nav-toggler").on('click', function() {
        $("#main-wrapper").toggleClass("show-sidebar");
        $(".nav-toggler i").toggleClass("ri-menu-2-line");
        $("body").trigger("resize");
    });
    $(".nav-lock").on('click', function() {
        $("body").toggleClass("lock-nav");
        $(".nav-lock i").toggleClass("mdi-toggle-switch-off");
        $("body, .page-wrapper").trigger("resize");
    });
    $(".search-box a, .search-box .app-search .srh-btn").on('click', function() {
        $(".app-search").toggle(200);
        $(".app-search input").focus();
    });

    // ==============================================================
    // Right sidebar options
    // ==============================================================
    $(function() {
        $(".service-panel-toggle").on('click', function() {
            $(".customizer").toggleClass('show-service-panel');

        });
        $('.page-wrapper').on('click', function() {
            $(".customizer").removeClass('show-service-panel');
        });
    });
    // ==============================================================
    // This is for the floating labels
    // ==============================================================
    $('.floating-labels .form-control').on('focus blur', function(e) {
        $(this).parents('.form-group').toggleClass('focused', (e.type === 'focus' || this.value.length > 0));
    }).trigger('blur');

    // ==============================================================
    //tooltip
    // ==============================================================
    //$('[data-bs-toggle="tooltip"]').tooltip()
    $(function() {
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
        var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
          return new bootstrap.Tooltip(tooltipTriggerEl)
        })
    })
    // ==============================================================
    //Popover
    // ==============================================================
    $(function() {
        var popoverTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="popover"]'))
        var popoverList = popoverTriggerList.map(function (popoverTriggerEl) {
          return new bootstrap.Popover(popoverTriggerEl)
        })
    })

    // ==============================================================
    // Perfact scrollbar
    // ==============================================================
    $('.message-center, .customizer-body, .scrollable').perfectScrollbar({
        wheelPropagation: !0
    });

    /*var ps = new PerfectScrollbar('.message-body');
    var ps = new PerfectScrollbar('.notifications');
    var ps = new PerfectScrollbar('.scroll-sidebar');
    var ps = new PerfectScrollbar('.customizer-body');*/

    // ==============================================================
    // Resize all elements
    // ==============================================================
    $("body, .page-wrapper").trigger("resize");
    $(".page-wrapper").delay(20).show();
    // ==============================================================
    // To do list
    // ==============================================================
    $(".list-task li label").click(function() {
        $(this).toggleClass("task-done");
    });
    // ==============================================================
    // Collapsable cards
    // ==============================================================
    $('a[data-action="collapse"]').on("click", function (e) {
        e.preventDefault();
        $(this)
          .closest(".card")
          .find('[data-action="collapse"] i')
          .toggleClass("ri-subtract-line ri-add-line");
        $(this).closest(".card").children(".card-body").collapse("toggle");
      });
      // Toggle fullscreen
      $('a[data-action="expand"]').on("click", function (e) {
        e.preventDefault();
        $(this)
          .closest(".card")
          .find('[data-action="expand"] i')
          .toggleClass("ri-fullscreen-line ri-fullscreen-exit-line");
        $(this).closest(".card").toggleClass("card-fullscreen");
      });
    // Close Card
    $('a[data-action="close"]').on('click', function() {
        $(this).closest('.card').removeClass().slideUp('fast');
    });
    // ==============================================================
    // LThis is for mega menu
    // ==============================================================
    $('.mega-dropdown').on('click', function(e) {
        e.stopPropagation()
    });
    // ==============================================================
    // Last month earning
    // ==============================================================
    var sparklineLogin = function() {
        $('.lastmonth').sparkline([6, 10, 9, 11, 9, 10, 12], {
            type: 'bar',
            height: '35',
            barWidth: '4',
            width: '100%',
            resize: true, 
            barSpacing: '8',
            barColor: '#2961ff'
        });

    };
    var sparkResize;

    $(window).resize(function(e) {
        clearTimeout(sparkResize);
        sparkResize = setTimeout(sparklineLogin, 500);
    });
    sparklineLogin();

    // ==============================================================
    // This is for the innerleft sidebar
    // ==============================================================
    $(".show-left-part").on('click', function() {
        $('.left-part').toggleClass('show-panel');
        $(".show-left-part").toggleClass("ri-menu-fill");
    });

}); 


  var isIOS = ((/iphone|ipad/gi).test(navigator.appVersion));
  var myevent = isIOS ? "touchstart" : "click";
  var menter = isIOS ? "touchstart" : "mouseenter";
  var mleave = isIOS ? "touchend" : "mouseleave";
  $(document).ready(function () {
  
      $(".dropdown:has(ul)").hover(function () {
          $(this).find("ul").stop("true", "true").slideDown(500);
      }, function () {
          $(this).find("ul").stop("true", "true").slideUp(500);
      });

      // Hide alert
      $('body').on('click', '.close', function () {
          var dvData = $(this).parent().parent();
          setTimeout(function () {
                  $(dvData).fadeOut("slow",
                      function () {
                          $(dvData).remove();
                      });
              },
              100);
      });


      // Clear input fields on focus
      $('input').each(function () {
          var default_value = this.value;
          $(this).focus(function () {
              if (this.value == default_value) {
                  this.value = '';
              }
          });
          $(this).blur(function () {
              if (this.value == '') {
                  this.value = default_value;
              }
          });
      });



      /* == Tooltip == */
      var targets = $('body'),
          target = false,
          tooltip = false,
          title = false;
      targets.on(menter, ".tooltip", function () {
          target = $(this);
          tip = target.attr('data-title');
          tooltip = $('<div id="tooltip"></div>');
          if (!tip || tip == '') return false;
          target.removeAttr('data-title');
          tooltip.css('opacity', 0)
              .html(tip)
              .appendTo('html');
          var init_tooltip = function (e) {
              if ($(window).width() < tooltip.outerWidth() * 1.5) tooltip.css('max-width', $(window).width() / 2);
              else tooltip.css('max-width', 340);
              var pos_left = target.offset().left + (target.outerWidth() / 2) - (tooltip.outerWidth() / 2),
                  pos_top = target.offset().top - tooltip.outerHeight() - 20;
              if (pos_left < 0) {
                  pos_left = target.offset().left + target.outerWidth() / 2 - 20;
                  tooltip.addClass('left');
              } else tooltip.removeClass('left');
              if (pos_left + tooltip.outerWidth() > $(window).width()) {
                  pos_left = target.offset().left - tooltip.outerWidth() + target.outerWidth() / 2 + 20;
                  tooltip.addClass('right');
              } else tooltip.removeClass('right');
              if (pos_top < 0) {
                  var pos_top = target.offset().top + target.outerHeight();
                  tooltip.addClass('top');
              } else tooltip.removeClass('top');
              tooltip.css({
                  left: pos_left,
                  top: pos_top
              })
                  .animate({
                      top: '+=10',
                      opacity: 1
                  }, 50);
          };
          init_tooltip();

          $(window).resize(init_tooltip);
          var remove_tooltip = function () {
              tooltip.animate({
                  top: '-=10',
                  opacity: 0
              }, 50, function () {
                  $(this).remove();
              });
              target.attr('data-title', tip);
          };
          target.on(mleave, remove_tooltip);
          tooltip.on(myevent, remove_tooltip);
      });

      $('#settingslist').hide();
      $('a#showhide').click(function () {
          $('#settingslist').slideToggle();
          return false;
      });
      $('a.minilist').click(function () {
          $('#settingslist2').toggle();
          return false;
      });

      /* == Admin Menu == */
      $('ul.nav li').on('click', function () {
          $(this).addClass("hover");
          $('ul:first',this).slideToggle("fast");
      });
      $("ul.nav li:has(ul)").find("a:first").append("&nbsp;...");

 
      
      $("button#do-passreset").click(function () {
        $("#show-passreset").slideToggle();
      });
  });
  
  function showLoader() {
      $("#loader").fadeIn(200);
  }

  function hideLoader() {
      $("#loader").fadeOut(200);
  };
  
  function showsLoader(id) {
      $(id + ' .loading').fadeIn(200);
  }

  function hidesLoader(id) {
      $(id + ' .loading').fadeOut(200);
  };
