// -------------------------------------------------------------------------------------------------------------------------------------------
// Dashboard 7 : Chart Init Js
// -------------------------------------------------------------------------------------------------------------------------------------------
$(function() {
    "use strict";


    


    // -----------------------------------------------------------------------
    // page views
    // -----------------------------------------------------------------------
    var views = {
        series: [{
            name: "Views ",
            data: [6, 10, 9, 11, 9, 10, 12]
        }],
        chart: {
            type: 'area',
            height: 65,
            zoom: {
                enabled: false
            },
            toolbar: {
                show: false,
            },
            sparkline: {
                enabled: true
            },
        },
        grid: {
            show: false,
        },
        dataLabels: {
            enabled: false
        },
        stroke: {
            curve: 'straight',
            width: 1,
            colors: ["rgba(255,255,255,.2)"]
        },
        xaxis: {
            axisBorder: {
                show: false,
            },
            axisTicks: {
                show: false,
            },
            labels: {
                show: false,
            },
        },
        yaxis: {
            labels: {
                show: false,
            },
        },
        markers: {
            size: 0,
            strokeColors: 'transparent',
            strokeWidth: 2,
            shape: "circle",
            colors: ["#fff"],
        },
        fill: {
            type: 'gradient',
            gradient: {
                shadeIntensity: 1,
                opacityFrom: 0.5,
                opacityTo: 0.5,
                stops: [0, 90, 100]
            },
            colors: ['#fff', '#4fc3f7']
        },
        tooltip: {
            theme: "dark",
            style: {
                fontFamily: '"Nunito Sans", sans- serif',
            },
            x: {
                show: false,
            },
            y: {
                formatter: undefined,
            },
            marker: {
                show: false,
            },
            followCursor: true,
        },
        legend: {
            show: false
        }
    };

    var chart_area_basic = new ApexCharts(document.querySelector(".page-views"), views);
    chart_area_basic.render();

    // -----------------------------------------------------------------------
    // bounce rate
    // -----------------------------------------------------------------------
    var bouncerate = {
        series: [{
            name: "Rate ",
            labels: ["2012", "2013", "2014", "2015", "2016", "2017"],
            data: [12, 19, 3, 8, 2, 3]
        }],
        chart: {
            width: 150,
            height: 55,
            type: 'line',
            toolbar: {
                show: false
            },
            sparkline: {
                enabled: true
            },
        },
        fill: {
            type: 'solid',
            opacity: 1,
            colors: ['#2962ff']
        },
        grid: {
            show: false,
        },
        stroke: {
            curve: 'smooth',
            lineCap: 'square',
            colors: ['#2962ff'],
            width: 3,
        },
        markers: {
            size: 3,
            colors: ['#2962ff'],
            strokeColors: 'transparent',
            shape: 'square',
            hover: {
                size: 7,
            }
        },
        xaxis: {
            axisBorder: {
                show: false,
            },
            axisTicks: {
                show: false,
            },
            labels: {
                show: false,
            },
        },
        fill: {
            type: 'solid',
            colors: ['#FDD835'],
        },
        yaxis: {
            labels: {
                show: false,
            },
        },
        tooltip: {
            theme: "dark",
            style: {
                fontFamily: '"Nunito Sans", sans- serif',
            },
            x: {
                show: false
            },
            y: {
                formatter: undefined,
            },
            marker: {
                show: false,
            },
            followCursor: true,
        },
    };

    var chart_line_basic = new ApexCharts(document.querySelector(".bounce-rate"), bouncerate);
    chart_line_basic.render();
});