"use strict";

$(function () {

  $.ajax({
    url: './ajax/dashboard/shipments/load_graphics_packages_registered_ajax.php',
    type: "POST",
    dataType: "json",
    success: function (data) {

      console.log(data);

     // -----------------------------------------------------------------------
    // bounce rate
    // -----------------------------------------------------------------------
    var bouncerate = {
        series: [{
            name: "Shipment registered: ",
            labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
            data: data
        }],
        chart: {
            height: 80,
            type: 'line',
            toolbar: {
                show: false 
            },
            sparkline: {
                enabled: true
            },
        },
        fill: {
            type: 'solid',
            opacity: 1,
            colors: ['#2962ff']
        },
        grid: {
            show: false,
        },
        stroke: {
            curve: 'smooth',
            lineCap: 'square',
            colors: ['#2962ff'],
            width: 3,
        },
        markers: {
            size: 3,
            colors: ['#2962ff'],
            strokeColors: 'transparent',
            shape: 'square',
            hover: {
                size: 7,
            }
        },
        xaxis: {
            show: true
        },
        fill: {
            type: 'solid',
            colors: ['#FDD835'],
        },
        yaxis: {
            labels: {
                show: false,
            },
        },
        tooltip: {
            theme: "dark",
            style: {
                fontFamily: '"Nunito Sans", sans- serif',
            },
            x: {
                show: false
            },
            y: {
                formatter: undefined,
            },
            marker: {
                show: false,
            },
            followCursor: true,
        },
    };
    var chart_line_basic = new ApexCharts(document.querySelector("#bouncerate"), bouncerate);
    chart_line_basic.render();
        
    

    },
    error: function (data) {

    },
  });

  cdp_load(1);

});


//Cargar datos AJAX
function cdp_load(page) {

  var parametros = { "page": page };
  $("#loader").fadeIn('slow');
  $.ajax({
    url: './ajax/dashboard/shipments/load_packages_registered_ajax.php',
    data: parametros,
    beforeSend: function (objeto) {
    },
    success: function (data) {
      $(".outer_div").html(data).fadeIn('slow');
    }
  })
}


