"use strict";

$(function () {

  $.ajax({
    url: './ajax/dashboard/shipments/load_graphics_shipments_registered_ajax.php',
    type: "POST",
    dataType: "json",
    success: function (data) {

      console.log(data);

            // ------------------------------
    // Basic line chart
    // ------------------------------
    // based on prepared DOM, initialize echarts instance
        var myChart = echarts.init(document.getElementById('basic-line'));

        // specify chart configuration item and data
        var option = {
                // Setup grid
                grid: {
                     left: '1%',
                    right: '2%',
                    bottom: '3%',
                    containLabel: true
                },

                // Add Tooltip
                tooltip : {
                    trigger: 'axis'
                },

                // Add Legend
                legend: {
                    data:['Shipments Registered']
                },

                // Add custom colors
                color: ['#2962FF'],

                // Enable drag recalculate
                calculable : true,

                // Horizontal Axiz
                xAxis : [
                    {
                        type : 'category',
                        boundaryGap : true,
                        data : ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec']
                    }
                ],

                // Vertical Axis
                yAxis : [
                    {
                        type : 'value',
                        axisLabel : {
                            formatter: '{value} '
                        }
                    }
                ],

                // Add Series
                series : [
                    {
                        name:'Shipments Registered',
                        type:'line',
                        data: data,
                        markPoint : {
                            data : [
                                {type : 'max', name: 'Max'}
                            ]
                        },
                        markLine : {
                            data : [
                                {type : 'average', name: 'Average'}
                            ]
                        },
                        lineStyle: {
                            normal: {
                                width: 3,
                                shadowColor: 'rgba(0,0,0,0.1)',
                                shadowBlur: 10,
                                shadowOffsetY: 10
                            }
                        },
                    }
                ]
            };
        // use configuration item and data specified to show chart
        myChart.setOption(option);
        
    

    },
    error: function (data) {

    },
  });

  cdp_load(1);

});


//Cargar datos AJAX
function cdp_load(page) {

  var parametros = { "page": page };
  $("#loader").fadeIn('slow');
  $.ajax({
    url: './ajax/dashboard/shipments/load_shipments_ajax.php',
    data: parametros,
    beforeSend: function (objeto) {
    },
    success: function (data) {
      $(".outer_div").html(data).fadeIn('slow');
    }
  })
}


