"use strict";

var errorMsg = document.querySelector("#error-msg");
var validMsg = document.querySelector("#valid-msg");

// here, the index maps to the error code returned from getValidationError - see readme
var errorMap = ["Invalid number", "Invalid country code", "Too short", "Too long", "Invalid number"];


var input = document.querySelector("#phone_custom");
var iti = window.intlTelInput(input, {

  geoIpLookup: function (callback) {
    $.get("http://ipinfo.io", function () { }, "jsonp").always(function (resp) {
      var countryCode = (resp && resp.country) ? resp.country : "";
      callback(countryCode);
    });
  },
  initialCountry: "auto",
  nationalMode: true,

  separateDialCode: true,
  utilsScript: "dist/js/input-js/utils.js",
});




var reset = function () {
  input.classList.remove("error");
  errorMsg.innerHTML = "";
  errorMsg.classList.add("hide");
  validMsg.classList.add("hide");
};

// on blur: validate
input.addEventListener('blur', function () {
  reset();
  if (input.value.trim()) {

    if (iti.isValidNumber()) {

      $('#phone').val(iti.getNumber());

      validMsg.classList.remove("hide");

    } else {

      input.classList.add("error");
      var errorCode = iti.getValidationError();
      errorMsg.innerHTML = errorMap[errorCode];
      errorMsg.classList.remove("hide");

    }
  }
});

// on keyup / change flag: reset
input.addEventListener('change', reset);
input.addEventListener('keyup', reset);


//Registro de datos

$("#save_user").on('submit', function (event) {


  // if(validate==0){
  if (iti.isValidNumber()) {


    $('#save_data').attr("disabled", true);
    var parametros = $(this).serialize();

    var username = $('#username').val();
    var email = $('#email').val();
    var fname = $('#fname').val();
    var lname = $('#lname').val();
    var phone = $('#phone').val();
    var locker = $('#locker').val();
    var country = $('#country').val();
    var city = $('#city').val();
    var address = $('#address').val();
    var terms = $('#terms').val();
    var pass = $('#pass').val();
    var pass2 = $('#pass2').val();


    var data = new FormData();

    
    data.append('username', username);
    data.append('email', email);
    data.append('fname', fname);
    data.append('lname', lname);
    data.append('phone', phone);
    data.append('locker', locker);
    data.append('country', country);
    data.append('city', city);
    data.append('address', address);
    data.append('terms', terms);
    data.append('pass', pass);
    data.append('pass2', pass2);
    

    $.ajax({

      type: "POST",
      url: "ajax/sign_up_ajax.php",
      data: data,
      contentType: false,       // The content type used when sending data to the server.
      cache: false,             // To unable request pages to be cached
      processData: false,
      beforeSend: function (objeto) {
        $("#resultados_ajax").html("Please wait...");
      },
      success: function (datos) {
        $("#resultados_ajax").html(datos);
        $('#save_data').attr("disabled", false);

        $('html, body').animate({
          scrollTop: 0
        }, 600);

      }
    });

  } else {

    input.classList.add("error");
    var errorCode = iti.getValidationError();
    errorMsg.innerHTML = errorMap[errorCode];
    errorMsg.classList.remove("hide");
    $('#phone_custom').focus();


  }



  event.preventDefault();

})


