<?php
// *************************************************************************
// *                                                                       *
// * DEPRIXA BASIC -  Freight Forwarding & Shipping Software Solutions     *
// * Copyright (c) JAOMWEB. All Rights Reserved                            *
// *                                                                       *
// *************************************************************************
// *                                                                       *
// * Email: support@jaom.info                                              *
// * Website: https://deprixa.link/documentation/                          *
// *                                                                       *
// *************************************************************************
// *                                                                       *
// * This software is furnished under a license and may be used and copied *
// * only  in  accordance  with  the  terms  of such  license and with the *
// * inclusion of the above copyright notice.                              *
// * If you Purchased from Codecanyon, Please read the full License from   *
// * here- http://codecanyon.net/licenses/standard                         *
// *                                                                       *
// *************************************************************************



require_once("loader.php");

$login = new User;
$core = new Core;

?>

<!DOCTYPE html>
<html lang="en" data-theme="system">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0 shrink-to-fit=no">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="keywords" content="Deprixa basic 3.0">
    <meta name="author" content="Jaomweb">
    <meta name="description" content="">
    <title><?php echo $lang['leftorder275'] ?>, <?php echo $lang['leftorder276'] ?> | <?php echo $core->site_name ?></title>
    <link rel="icon" type="image/png" sizes="16x16" href="assets/<?php echo $core->favicon ?>">

    <link href="https://fonts.googleapis.com/css2?family=Work+Sans:wght@400;500;600&amp;display=swap" rel="stylesheet">
    <link href="assets/dist/css/screen.min.css" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="assets/dist/css/cards.min.css">

    <link href="https://fonts.googleapis.com/css?family=Lato:300,400,700,900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://md-aqil.github.io/images/swiper.min.css">


</head>

<body class="home-template" data-nav="sticky">
    <div class="site-wrap">
        <header class="site-header">
            <div class="container header-inner justify-space-between">
                <div class="header-logo flex">
                    <a href="index.php" class="">

                        <?php echo ($core->logo_web) ? '<img src="assets/' . $core->logo_web . '" alt="' . $core->site_name . '" width="' . $core->thumb_web . '" height="' . $core->thumb_hweb . '"/>' : $core->site_name; ?>
                    </a>
                </div>

                <input id="mobile-menu-toggle" class="mobile-menu-checkbox" type="checkbox">
                <label for="mobile-menu-toggle" class="mobile-menu-icon" aria-label="menu toggle button">
                    <span class="line"></span>
                    <span class="line"></span>
                    <span class="line"></span>
                    <span class="sr-only">Menu toggle button</span>
                </label>
                <div class="header-right flex" data-theme-icon="true">
                    <nav class="header-nav" role="navigation" aria-label="Main navigation">
                        <ul class="header-nav-list no-style-list" role="menu">
                            <li class="nav-item" role="menuitem">
                                <a href="index.php" class="nav-current"><?php echo $lang['left111'] ?></a>
                            </li>
                            <li class="nav-item" role="menuitem">
                                <a href="about_us.php"><?php echo $lang['left123_ab'] ?></a>
                            </li>

                            <li class="nav-item" role="menuitem">
                                <a href="track.php"><?php echo $lang['left113'] ?></a>
                            </li>

                            <li class="nav-item" role="menuitem">
                                <a href="view.php"><?php echo $lang['left168'] ?></a>
                            </li>
                            <li class="nav-item" role="menuitem">
                                <a class="btn btn-menuitem" href="sign-up.php"><?php echo $lang['tools-login7'] ?></a>
                            </li>
                        </ul>
                    </nav>

                </div>
            </div>
        </header>

        <section class="home-cover-area">
            <div class="container">
                <div class="row home-cover-wrap has-cover-image">
                    <div class="col-lg-7">
                        <div class="cover-img-container">
                            <div class="">
                                <img src="assets/images/content_web/logistic_best.png" alt="">
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-5">
                        <div class="home-cover-content-wrap">
                            <h1 class="heading-large"><?php echo $lang['leftorder275'] ?></h1>
                            <div class="intro-description">
                                <?php echo $lang['leftorder276'] ?>
                            </div>
                            <form method="POST" name="ib_form" id="ib_form" class="members-form cover-subscribe-form text-left">
                                <div class="col-md-12" style="display: none;">
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" name="trackingType" id="trackingType" value="1" checked>
                                        <label class="form-check-label" for="trackingType">Shipments</label>
                                    </div>
                                </div>
                                <div class="field-group-inline">
                                    <label for="header-form-email" class="sr-only"><?php echo $lang['leftorder273'] ?></label>
                                    <input type="text" class="form-field input-field" name="order_track" placeholder="<?php echo $lang['leftorder272'] ?>" id="order_track" required="" autocomplete="off">
                                    <button type="submit" name="submit" class="btn "><span><?php echo $lang['leftorder274'] ?></span></button>
                                </div>
                            </form>

                            <div class="social-links-wrap flex">
                                <span class="title"><?php echo $lang['leftorder277'] ?></span>
                                <div class="social-links flex">
                                    <a href="#" aria-label="twitter link"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                            <path d="M24 4.557c-.883.392-1.832.656-2.828.775 1.017-.609 1.798-1.574 2.165-2.724-.951.564-2.005.974-3.127 1.195-.897-.957-2.178-1.555-3.594-1.555-3.179 0-5.515 2.966-4.797 6.045-4.091-.205-7.719-2.165-10.148-5.144-1.29 2.213-.669 5.108 1.523 6.574-.806-.026-1.566-.247-2.229-.616-.054 2.281 1.581 4.415 3.949 4.89-.693.188-1.452.232-2.224.084.626 1.956 2.444 3.379 4.6 3.419-2.07 1.623-4.678 2.348-7.29 2.04 2.179 1.397 4.768 2.212 7.548 2.212 9.142 0 14.307-7.721 13.995-14.646.962-.695 1.797-1.562 2.457-2.549z"></path>
                                        </svg></a>
                                    <a href="#" aria-label="facebook link"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                            <path d="M9 8h-3v4h3v12h5v-12h3.642l.358-4h-4v-1.667c0-.955.192-1.333 1.115-1.333h2.885v-5h-3.808c-3.596 0-5.192 1.583-5.192 4.615v3.385z"></path>
                                        </svg></a>
                                    <a href="#" aria-label="instagram link"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                            <path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z"></path>
                                        </svg></a>
                                    <a href="#" aria-label="github link"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                            <path d="M12 0c-6.626 0-12 5.373-12 12 0 5.302 3.438 9.8 8.207 11.387.599.111.793-.261.793-.577v-2.234c-3.338.726-4.033-1.416-4.033-1.416-.546-1.387-1.333-1.756-1.333-1.756-1.089-.745.083-.729.083-.729 1.205.084 1.839 1.237 1.839 1.237 1.07 1.834 2.807 1.304 3.492.997.107-.775.418-1.305.762-1.604-2.665-.305-5.467-1.334-5.467-5.931 0-1.311.469-2.381 1.236-3.221-.124-.303-.535-1.524.117-3.176 0 0 1.008-.322 3.301 1.23.957-.266 1.983-.399 3.003-.404 1.02.005 2.047.138 3.006.404 2.291-1.552 3.297-1.23 3.297-1.23.653 1.653.242 2.874.118 3.176.77.84 1.235 1.911 1.235 3.221 0 4.609-2.807 5.624-5.479 5.921.43.372.823 1.102.823 2.222v3.293c0 .319.192.694.801.576 4.765-1.589 8.199-6.086 8.199-11.386 0-6.627-5.373-12-12-12z" />
                                        </svg></a>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>

        </section>

        <section class="email-subs">
            <hr>
            <div class="centered-page-header text-center">
                <h1 class="heading mb-1">Simple Shipping Worldwide</span></h1>
            </div>
            <br>
            <div class="testimoniall-section">

                <div class="testi-user-img">
                    <div class="swiper-container gallery-thumbs">
                        <div class="swiper-wrapper">
                            <div class="swiper-slide">
                                <img class="u3" src="assets/images/content_web/slide_service1.jpg" alt="">
                            </div>
                            <div class="swiper-slide">
                                <img class="u1" src="assets/images/content_web/slide_service2.jpg" alt="">
                            </div>
                            <div class="swiper-slide">
                                <img class="u2" src="assets/images/content_web/slide_service3.jpg" alt="">
                            </div>

                            <div class="swiper-slide">
                                <img class="u4" src="assets/images/content_web/slide_service4.jpg" alt="">
                            </div>

                        </div>
                    </div>
                </div>
                <div class="user-saying">
                    <div class="swiper-container testimoniall">
                        <!-- Additional required wrapper -->
                        <div class="swiper-wrapper ">
                            <!-- Slides -->
                            <div class="swiper-slide">
                                <div class="quote">
                                    <img class="quote-icon" src="https://md-aqil.github.io/images/quote.png" alt="">
                                    <p>
                                        “This is best and biggest unified platform
                                        for instant online admission. We can easily
                                        take admission for any course in any institute..“
                                    </p>
                                    <div class="name">-Ramkishor Verma-</div>
                                    <div class="designation">University Student</div>

                                </div>
                            </div>
                            <div class="swiper-slide">
                                <div class="quote">
                                    <img class="quote-icon" src="https://md-aqil.github.io/images/quote.png" alt="">

                                    <p>
                                        “This is best and biggest unified platform
                                        for instant online admission. We can easily
                                        take admission for any course in any institute..“
                                    </p>
                                    <div class="name">-Ramkishor Verma-</div>
                                    <div class="designation">University Student</div>

                                </div>
                            </div>
                            <div class="swiper-slide">
                                <div class="quote">
                                    <img class="quote-icon" src="https://md-aqil.github.io/images/quote.png" alt="">

                                    <p>
                                        “This is best and biggest unified platform
                                        for instant online admission. We can easily
                                        take admission for any course in any institute..“
                                    </p>
                                    <div class="name">-Ramkishor Verma-</div>
                                    <div class="designation">University Student</div>

                                </div>
                            </div>
                            <div class="swiper-slide">
                                <div class="quote">
                                    <img class="quote-icon" src="https://md-aqil.github.io/images/quote.png" alt="">

                                    <p>
                                        “This is best and biggest unified platform
                                        for instant online admission. We can easily
                                        take admission for any course in any institute..“
                                    </p>
                                    <div class="name">-Ramkishor Verma-</div>
                                    <div class="designation">University Student</div>

                                </div>
                            </div>

                        </div>
                        <!-- If we need pagination -->
                        <div class="swiper-pagination swiper-pagination-white"></div>

                    </div>
                </div>
            </div>
        </section>


        <div class="main">
            <div class="container">
                <div class="row">
                    <div class="col-lg-10 offset-lg-1">
                        <hr>
                        <div class="centered-page-header text-center">
                            <h2 class="heading mb-1 text-violet"><?php echo $lang['leftorder278'] ?> </span></h2>
                        </div>
                        <article class="single-post flex">
                            <div class="post-content">
                                <div class="title-heading text-center mt-1">
                                    <table class="pricing-table">

                                        <tr>
                                            <th><?php echo $lang['leftorder279'] ?> </th>
                                            <th><?php echo $lang['leftorder280'] ?> <span> <?php echo $lang['leftorder281'] ?> </span></th>
                                            <th><?php echo $lang['leftorder282'] ?> <span> <?php echo $lang['leftorder281'] ?> </span></th>
                                        </tr>

                                        <tr>
                                            <td>CHINA - PANAMA</td>

                                            <td>From $15</td>
                                            <td>From $16</td>
                                        </tr>
                                        <tr>
                                            <td>China-Venezuela</td>
                                            <td>From $25</td>
                                            <td>From $16</td>
                                        </tr>
                                        <tr>
                                            <td>Panama-Venezuela</td>
                                            <td>From $17</td>
                                            <td>From $4,50</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </article>
                    </div>
                </div>
            </div>
        </div>


        <footer class="site-footer">
            <div class="container">

                <div class="footer-bottom flex justify-space-between">
                    <div class="social-links-wrap flex">
                        <span class="title"><?php echo $lang['leftorder277'] ?></span>
                        <div class="social-links flex">
                            <a href="#" aria-label="twitter link"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                    <path d="M24 4.557c-.883.392-1.832.656-2.828.775 1.017-.609 1.798-1.574 2.165-2.724-.951.564-2.005.974-3.127 1.195-.897-.957-2.178-1.555-3.594-1.555-3.179 0-5.515 2.966-4.797 6.045-4.091-.205-7.719-2.165-10.148-5.144-1.29 2.213-.669 5.108 1.523 6.574-.806-.026-1.566-.247-2.229-.616-.054 2.281 1.581 4.415 3.949 4.89-.693.188-1.452.232-2.224.084.626 1.956 2.444 3.379 4.6 3.419-2.07 1.623-4.678 2.348-7.29 2.04 2.179 1.397 4.768 2.212 7.548 2.212 9.142 0 14.307-7.721 13.995-14.646.962-.695 1.797-1.562 2.457-2.549z"></path>
                                </svg></a>
                            <a href="#" aria-label="facebook link"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                    <path d="M9 8h-3v4h3v12h5v-12h3.642l.358-4h-4v-1.667c0-.955.192-1.333 1.115-1.333h2.885v-5h-3.808c-3.596 0-5.192 1.583-5.192 4.615v3.385z"></path>
                                </svg></a>
                            <a href="#" aria-label="instagram link"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                    <path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z"></path>
                                </svg></a>
                            <a href="#" aria-label="github link"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                    <path d="M12 0c-6.626 0-12 5.373-12 12 0 5.302 3.438 9.8 8.207 11.387.599.111.793-.261.793-.577v-2.234c-3.338.726-4.033-1.416-4.033-1.416-.546-1.387-1.333-1.756-1.333-1.756-1.089-.745.083-.729.083-.729 1.205.084 1.839 1.237 1.839 1.237 1.07 1.834 2.807 1.304 3.492.997.107-.775.418-1.305.762-1.604-2.665-.305-5.467-1.334-5.467-5.931 0-1.311.469-2.381 1.236-3.221-.124-.303-.535-1.524.117-3.176 0 0 1.008-.322 3.301 1.23.957-.266 1.983-.399 3.003-.404 1.02.005 2.047.138 3.006.404 2.291-1.552 3.297-1.23 3.297-1.23.653 1.653.242 2.874.118 3.176.77.84 1.235 1.911 1.235 3.221 0 4.609-2.807 5.624-5.479 5.921.43.372.823 1.102.823 2.222v3.293c0 .319.192.694.801.576 4.765-1.589 8.199-6.086 8.199-11.386 0-6.627-5.373-12-12-12z" />
                                </svg></a>
                        </div>
                    </div>

                    <div class="copyright">
                        &copy; <?php echo date('Y') ?> <a href="index.php"><?php echo $core->site_name; ?></a> - <?php echo $lang['foot'] ?> </a>
                    </div>
                </div>
            </div>
        </footer>

    </div>


    <script src="assets/dist/js/app.bundle.min.js"></script>
    <script src="assets/dist/js/plugin/prism.js"></script>
    <script src="assets/libs/jquery/dist/jquery.min.js"></script>
    <script src="https://md-aqil.github.io/images/swiper.min.js"></script>
    <script src="dataJs/tracking.js"></script>

    <script type="text/javascript">
        var galleryThumbs = new Swiper('.gallery-thumbs', {
            effect: 'coverflow',
            grabCursor: true,
            centeredSlides: true,
            slidesPerView: '2',
            // coverflowEffect: {
            //   rotate: 50,
            //   stretch: 0,
            //   depth: 100,
            //   modifier: 1,
            //   slideShadows : true,
            // },

            coverflowEffect: {
                rotate: 0,
                stretch: 0,
                depth: 50,
                modifier: 6,
                slideShadows: false,
            },

        });


        var galleryTop = new Swiper('.swiper-container.testimoniall', {
            speed: 400,
            spaceBetween: 50,
            autoplay: {
                delay: 3000,
                disableOnInteraction: false,
            },
            direction: 'vertical',
            pagination: {
                clickable: true,
                el: '.swiper-pagination',
                type: 'bullets',
            },
            thumbs: {
                swiper: galleryThumbs
            }
        });
    </script>
</body>


</html>