<?php
// *************************************************************************
// *                                                                       *
// * DEPRIXA BASIC -  Freight Forwarding & Shipping Software Solutions     *
// * Copyright (c) JAOMWEB. All Rights Reserved                            *
// *                                                                       *
// *************************************************************************
// *                                                                       *
// * Email: support@jaom.info                                              *
// * Website: https://deprixa.link/documentation/                          *
// *                                                                       *
// *************************************************************************
// *                                                                       *
// * This software is furnished under a license and may be used and copied *
// * only  in  accordance  with  the  terms  of such  license and with the *
// * inclusion of the above copyright notice.                              *
// * If you Purchased from Codecanyon, Please read the full License from   *
// * here- http://codecanyon.net/licenses/standard                         *
// *                                                                       *
// *************************************************************************



require_once("loader.php");
require_once("helpers/querys.php");
require_once("helpers/phpmailer/class.phpmailer.php");
require_once("helpers/phpmailer/class.smtp.php");



session_start();
// get the HTML
ob_start();
if (!isset($_SESSION['userid'])) {

	header("location: login.php");
	exit;
}

if (isset($_GET['id'])) {
	$data = cdp_getConsolidatePrint($_GET['id']);
}




$row = $data['data'];

$core = new Core;
$db = new Conexion;

//Prefix tracking   
$sql = "SELECT * FROM cdb_settings";

$db->cdp_query($sql);

$db->cdp_execute();

$settings = $db->cdp_registro();

$order_prefix = $settings->prefix;
$siteemail = $settings->email_address;
$check_mail = $settings->mailer;
$names_info = $settings->smtp_names;
$mlogo = $settings->logo;
$msite_url = $settings->site_url;
$msnames = $settings->site_name;

//SMTP
$smtphoste = $settings->smtp_host;
$smtpuser = $settings->smtp_user;
$smtppass = $settings->smtp_password;
$smtpport = $settings->smtp_port;
$smtpsecure = $settings->smtp_secure;

$db->cdp_query("SELECT * FROM cdb_styles where id= '" . $row->status_courier . "'");
$status_courier = $db->cdp_registro();

$db->cdp_query("SELECT * FROM cdb_users where id= '" . $row->sender_id . "'");
$sender_data = $db->cdp_registro();

$db->cdp_query("SELECT * FROM cdb_users where id= '" . $row->receiver_id . "'");
$receiver_data = $db->cdp_registro();

$db->cdp_query("SELECT * FROM cdb_courier_com where id= '" . $row->order_courier . "'");
$courier_com = $db->cdp_registro();

$db->cdp_query("SELECT * FROM cdb_met_payment where id= '" . $row->order_pay_mode . "'");
$met_payment = $db->cdp_registro();

$db->cdp_query("SELECT * FROM cdb_shipping_mode where id= '" . $row->order_service_options . "'");
$order_service_options = $db->cdp_registro();

$db->cdp_query("SELECT * FROM cdb_packaging where id= '" . $row->order_package . "'");
$packaging = $db->cdp_registro();


$db->cdp_query("SELECT * FROM cdb_delivery_time where id= '" . $row->order_deli_time . "'");
$delivery_time = $db->cdp_registro();

$db->cdp_query("SELECT * FROM cdb_branchoffices where id= '" . $row->agency . "'");
$branchoffices = $db->cdp_registro();

$db->cdp_query("SELECT * FROM cdb_offices where id= '" . $row->origin_off . "'");
$offices = $db->cdp_registro();


$db->cdp_query("SELECT * FROM cdb_address_shipments where order_track='" . $row->c_prefix . $row->c_no . "'");
$address_order = $db->cdp_registro();


$db->cdp_query("SELECT * FROM cdb_consolidate_detail WHERE consolidate_id='" . $_GET['id'] . "'");
$order_items = $db->cdp_registros();

$dias_ = array("Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday");
$meses_ = array('01' => 'Jan', '02' => 'Feb', '03' => 'Mar', '04' => 'Apr', '05' => 'May', '06' => 'Jun', '07' => 'Jul', '08' => 'Aug', '09' => 'Sep', '10' => 'Oct', '11' => 'Nov', '12' => 'Dec');


$fecha = date("Y-m-d :h:i A", strtotime($row->order_datetime));

//SENDMAIL PHP

if ($check_mail == 'PHP') {


	require_once(dirname(__FILE__) . '/pdf/html2pdf.class.php');



	include(dirname('__FILE__') . '/pdf/documentos/html/consolidate_print.php');
	$content = ob_get_clean();

	try {
		// init HTML2PDF
		$html2pdf = new HTML2PDF('P', 'LETTER', 'es', true, 'UTF-8', array(0, 0, 0, 0));
		// display the full page
		$html2pdf->writeHTML($content, isset($_GET['vuehtml']));

		$to = strip_tags($_REQUEST['sendto']);
		$from = $smtpuser;
		$subject = strip_tags($_REQUEST['subject']);
		$message = strip_tags($_REQUEST['message']);
		$separator = md5(time());
		$eol = PHP_EOL;
		$filename = $row->c_prefix . $row->c_no . '.pdf';
		$pdfdoc = $html2pdf->Output('', 'S');
		$attachment = chunk_split(base64_encode($pdfdoc));

		$headers = "From: " . $from . $eol;
		$headers .= "MIME-Version: 1.0" . $eol;
		$headers .= "Content-Type: multipart/mixed; boundary=\"" . $separator . "\"" . $eol . $eol;


		$body = "";
		$body .= "Content-Transfer-Encoding: 7bit" . $eol;
		$body .= "This is a MIME encoded message." . $eol; //had one more .$eol


		$body .= "--" . $separator . $eol;
		$body .= "Content-Type: text/html; charset=\"iso-8859-1\"" . $eol;
		$body .= "Content-Transfer-Encoding: 8bit" . $eol . $eol;
		$body .= $message . $eol;


		$body .= "--" . $separator . $eol;
		$body .= "Content-Type: application/octet-stream; name=\"" . $filename . "\"" . $eol;
		$body .= "Content-Transfer-Encoding: base64" . $eol;
		$body .= "Content-Disposition: attachment" . $eol . $eol;
		$body .= $attachment . $eol;
		$body .= "--" . $separator . "--";


		if (mail($to, $subject, $body, $headers)) {
			echo "<div class='alert alert-success'>Message has been sent successfully!</div>";
		} else {
			echo "<div class='alert alert-warning'>Mensaje no enviado!!!</div>";
		}
	} catch (HTML2PDF_exception $e) {
		echo $e;
		exit;
	}
} elseif ($check_mail == 'SMTP') {


	//PHPMAILER PHP

	require_once(dirname(__FILE__) . '/pdf/html2pdf.class.php');



	include(dirname('__FILE__') . '/pdf/documentos/html/consolidate_print.php');
	$content = ob_get_clean();

	try {

		// init HTML2PDF
		$html2pdf = new HTML2PDF('P', 'LETTER', 'es', true, 'UTF-8', array(0, 0, 0, 0));
		// display the full page
		$html2pdf->writeHTML($content, isset($_GET['vuehtml']));

		$filename = $row->c_prefix . $row->c_no . '.pdf';
		$emailAttachment = $html2pdf->Output('', 'S');
		// send the PDF

		$destinatario = strip_tags($_REQUEST['sendto']);

		$mail = new PHPMailer(true);            // Passing `true` enables exceptions
      
         //Server settings
      
        $mail->isSMTP();                        // Set mailer to use SMTP
        $mail->Host = $smtphoste;               // Specify main and backup SMTP servers
        $mail->SMTPAuth = true;                 // Enable SMTP authentication
        $mail->Username = $smtpuser;            // SMTP username
        $mail->Password = $smtppass;            // SMTP password
        $mail->SMTPSecure = 'tls';              // Enable TLS encryption, `ssl` also accepted
        $mail->Port = 587;                      // TCP port to connect to

        //Recipients
        $mail->setFrom(''.$smtpuser.'', $names_info);
        $mail->addAddress($destinatario);       // Add a recipient
        $menssage = strip_tags($_REQUEST['message']);

        //Content
        $mail->isHTML(true); 
        $mail->CharSet = "utf-8";               // Set email format to HTML
        $mail->Subject = strip_tags($_REQUEST['subject']);
        $mail->Body = $menssage;
		$mail->AltBody = $menssage;
		$mail->AddStringAttachment($emailAttachment, '' . $filename . '', 'base64', 'application/pdf'); // attachment

        $mail->SMTPOptions = array(
                'ssl' => array(
                    'verify_peer' => false,
                    'verify_peer_name' => false,
                    'allow_self_signed' => true
                )
            );

        try {
            $mail->Send();
            echo "<div class='alert alert-success'>Message has been sent successfully!</div>";
        } catch (Exception $e) {
            echo 'Message could not be sent. Mailer Error: ', $mail->ErrorInfo;
        }
		// send the PDF


	} catch (HTML2PDF_exception $e) {
		echo $e;
		exit;
	}
}
