<?php
// *************************************************************************
// *                                                                       *
// * DEPRIXA BASIC -  Freight Forwarding & Shipping Software Solutions     *
// * Copyright (c) JAOMWEB. All Rights Reserved                            *
// *                                                                       *
// *************************************************************************
// *                                                                       *
// * Email: support@jaom.info                                              *
// * Website: https://deprixa.link/documentation/                          *
// *                                                                       *
// *************************************************************************
// *                                                                       *
// * This software is furnished under a license and may be used and copied *
// * only  in  accordance  with  the  terms  of such  license and with the *
// * inclusion of the above copyright notice.                              *
// * If you Purchased from Codecanyon, Please read the full License from   *
// * here- http://codecanyon.net/licenses/standard                         *
// *                                                                       *
// *************************************************************************


require_once("helpers/querys.php");
require_once("helpers/vendor/autoload.php");

use Twilio\Rest\Client;

require_once("helpers/phpmailer/class.phpmailer.php");
require_once("helpers/phpmailer/class.smtp.php");

$userData = $user->cdp_getUserData();


$db = new Conexion;

//Prefix tracking   
$sql = "SELECT * FROM cdb_settings";

$db->cdp_query($sql);

$db->cdp_execute();

$settings = $db->cdp_registro();

$order_prefix = $settings->prefix;
$siteemail = $settings->email_address;
$check_mail = $settings->mailer;
$names_info = $settings->smtp_names;
$mlogo = $settings->logo;
$msite_url = $settings->site_url;
$msnames = $settings->site_name;

//SMTP
$smtphoste = $settings->smtp_host;
$smtpuser = $settings->smtp_user;
$smtppass = $settings->smtp_password;
$smtpport = $settings->smtp_port;
$smtpsecure = $settings->smtp_secure;

$value_weight = $settings->value_weight;
$meter = $settings->meter;
//SMS TWILIO
$accountsid = $settings->twilio_sms_sid;
$authtoken = $settings->twilio_sms_token;
$twilionumbers = $settings->twilio_sms_number;

if (isset($_GET['id'])) {
    $data = cdp_getConsolidatePrint($_GET['id']);
}

if (!isset($_GET['id']) or $data['rowCount'] != 1) {
    cdp_redirect_to("consolidate_list.php");
}

$row = $data['data'];

$db->cdp_query("SELECT * FROM cdb_users where id= '" . $row->receiver_id . "'");
$receiver_data = $db->cdp_registro();

$office = $core->cdp_getOffices();
$statusrow = $core->cdp_getStatus();


$db->cdp_query("SELECT * FROM cdb_users where id= '" . $row->sender_id . "'");
$sender_data = $db->cdp_registro();


if (isset($_POST['address'])) {
    $db = new Conexion;


    $id = $_GET['id'];

    $errors = array();

    if (empty($_POST['t_date']))

        $errors['t_date'] = 'Please Enter Date';

    if (empty($_POST['address']))

        $errors['address'] = 'Please Enter address';

    if (intval($_POST['status_courier']) <= 0)

        $errors['status_courier'] = 'Please select status courier';

    if (intval($_POST['office']) <= 0)

        $errors['office'] = 'Please select office';

    if (empty($_POST['country']))

        $errors['country'] = 'Please select country';



    if (empty($errors)) {


        $db->cdp_query('UPDATE cdb_consolidate SET    
                         
                status_courier =:status_courier               
                where  consolidate_id=:id      
            ');


        $db->bind(':status_courier', $_POST['status_courier']);
        $db->bind(':id', $id);


        $db->cdp_execute();


        $order_track = $row->c_prefix . $row->c_no;
        $date = date('Y-m-d', strtotime(trim($_POST["t_date"])));
        $time = date("H:i:s");
        $date = $date . ' ' . $time;


        $db->cdp_query("
                INSERT INTO cdb_courier_track 
                (
                    order_track,
                    t_dest,
                    t_city,
                    comments,
                    t_date,
                    status_courier,
                    office_id,
                    user_id
                    )
                VALUES
                    (
                    :order_track,
                    :country,
                    :address,
                    :comments,
                    :t_date,
                    :status_courier,
                    :office,                   
                    :user_id
                    )
            ");



        $db->bind(':order_track',  $order_track);
        $db->bind(':country', cdp_sanitize($_POST['country']));
        $db->bind(':address', cdp_sanitize($_POST['address']));
        $db->bind(':comments', cdp_sanitize($_POST['comments']));
        $db->bind(':t_date',  trim($date));
        $db->bind(':status_courier', cdp_sanitize($_POST['status_courier']));
        $db->bind(':office', cdp_sanitize($_POST['office']));
        $db->bind(':user_id',  $_SESSION['userid']);

        $db->cdp_execute();

        //INSERT HISTORY USER
        $date = date("Y-m-d H:i:s");
        $db->cdp_query("
                INSERT INTO cdb_order_user_history 
                (
                    user_id,
                    order_id,
                    action,
                    date_history,
                    is_consolidate                  
                    )
                VALUES
                    (
                    :user_id,
                    :order_id,
                    :action,
                    :date_history,
                    :is_consolidate
                    )
            ");



        $db->bind(':order_id',  $id);
        $db->bind(':is_consolidate', '1');
        $db->bind(':user_id',  $_SESSION['userid']);
        $db->bind(':action', 'added status tracking to onsolidated');
        $db->bind(':date_history',  trim($date));
        $db->cdp_execute();


        // SAVE NOTIFICATION
        $db->cdp_query("
                INSERT INTO cdb_notifications 
                (
                    user_id,
                    order_id,
                    notification_description,
                    shipping_type,
                    notification_date

                )
                VALUES
                    (
                    :user_id,                    
                    :order_id,
                    :notification_description,
                    :shipping_type,
                    :notification_date                    
                    )
            ");



        $db->bind(':user_id',  $_SESSION['userid']);
        $db->bind(':order_id',  $_GET['id']);
        $db->bind(':notification_description', 'The consolidated status has been updated, check it');
        $db->bind(':shipping_type', '2');
        $db->bind(':notification_date',  date("Y-m-d H:i:s"));

        $db->cdp_execute();


        $notification_id = $db->dbh->lastInsertId();

        //NOTIFICATION TO DRIVER

        cdp_insertNotificationsUsers($notification_id, $row->driver_id);


        //NOTIFICATION TO ADMIN AND EMPLOYEES

        $users_employees = cdp_getUsersAdminEmployees();

        foreach ($users_employees as $key) {

            cdp_insertNotificationsUsers($notification_id, $key->id);
        }

        //NOTIFICATION TO CUSTOMER

        cdp_insertNotificationsUsers($notification_id, $row->sender_id);

        $sql = "SELECT * FROM cdb_settings";

        $db->cdp_query($sql);

        $db->cdp_execute();

        $settings = $db->cdp_registro();

        $site_email = $settings->site_email;
        $check_mail = $settings->mailer;
        $names_info = $settings->smtp_names;
        $mlogo      = $settings->logo;
        $msite_url  = $settings->site_url;
        $msnames    = $settings->site_name;

        //SMTP

        $smtphoste = $settings->smtp_host;
        $smtpuser = $settings->smtp_user;
        $smtppass = $settings->smtp_password;
        $smtpport = $settings->smtp_port;
        $smtpsecure = $settings->smtp_secure;



        $fullshipment = $row->c_prefix . $row->c_no;
        $date_ship   = date("Y-m-d H:i:s a");

        $app_url = $settings->site_url . 'track.php?order_track=' . $fullshipment;
        $subject = "Updated consolidate tracking, tracking number $fullshipment";
        $status_courier_deliver = "" . $_POST['status_courier'] . "";



        $email_template = cdp_getEmailTemplates(19);

        $body = str_replace(
            array(
                '[NAME]',
                '[TRACKING]',
                '[DELIVERY_TIME]',
                '[COURIER]',
                '[NEW_ADDRESS]',
                '[COMMENT]',
                '[URL]',
                '[URL_LINK]',
                '[SITE_NAME]',
                '[URL_SHIP]'
            ),
            array(
                $sender_data->fname . ' ' . $sender_data->lname,
                $fullshipment,
                $date_ship,
                $status_courier_deliver,
                $_POST['country'] . ' | ' . $_POST['address'],
                $_POST['comments'],
                $msite_url,
                $mlogo,
                $msnames,
                $app_url
            ),
            $email_template->body
        );


        $newbody = cdp_cleanOut($body);


        //SENDMAIL PHP

        if ($check_mail == 'PHP') {

            $message = $newbody;
            $to = $sender_data->email;
            $from = $smtpuser;

            $header = "MIME-Version: 1.0\r\n";
            $header .= "Content-type: text/html; charset=UTF-8 \r\n";
            $header .= "From: " . $from . " \r\n";

            mail($to, $subject, $message, $header);
        } elseif ($check_mail == 'SMTP') {


            //PHPMAILER PHP

            $destinatario = $sender_data->email;

            $mail = new PHPMailer(true);            // Passing `true` enables exceptions

            //Server settings

            $mail->isSMTP();                        // Set mailer to use SMTP
            $mail->Host = $smtphoste;               // Specify main and backup SMTP servers
            $mail->SMTPAuth = true;                 // Enable SMTP authentication
            $mail->Username = $smtpuser;            // SMTP username
            $mail->Password = $smtppass;            // SMTP password
            $mail->SMTPSecure = 'tls';              // Enable TLS encryption, `ssl` also accepted
            $mail->Port = 587;                      // TCP port to connect to

            //Recipients
            $mail->setFrom('' . $smtpuser . '', $names_info);
            $mail->addAddress($destinatario);       // Add a recipient

            //Content
            $mail->isHTML(true);
            $mail->CharSet = "utf-8";               // Set email format to HTML
            $mail->Subject = $subject;
            $mail->Body = "
            <html> 
            <body> 
            <p>{$newbody}</p>
            </body> 
            </html>
            <br />"; // Texto del email en formato HTML

            $mail->SMTPOptions = array(
                'ssl' => array(
                    'verify_peer' => false,
                    'verify_peer_name' => false,
                    'allow_self_signed' => true
                )
            );

            try {
                $mail->Send();
                //echo "El correo fue enviado correctamente.";
            } catch (Exception $e) {
                //echo "Ocurrió un error inesperado.";
            }
        }




        //TEMPLATE NOTIFY SMS SENDER

        // Input string
        $subjectVal_sender = cdp_getsmsTemplates(15);

        // Array containing search string
        $searchVal_sender = array("[NAME]", "[TRACK]", "[STATUS]", "[LINK]");

        // Array containing replace string from  search string
        $replaceVal_sender = array("" . $sender_data->fname . ' ' . $sender_data->lname . "", "" . $fullshipment . "", "" . $status_courier_deliver . "", "" . $app_url . "");

        $sender_body = $subjectVal_sender->body;

        // Function to replace string
        $resStr_sender = str_replace($searchVal_sender, $replaceVal_sender, $sender_body);

        $newbodyS_sender = $resStr_sender;


        //TEMPLATE NOTIFY SMS RECEIVER

        // Input string
        $subjectVal_receiver = cdp_getsmsTemplates(16);

        // Array containing search string
        $searchVal_receiver = array("[NAME]", "[TRACK]", "[STATUS]", "[LINK]");

        // Array containing replace string from  search string
        $replaceVal_receiver = array("" . $sender_data->fname . ' ' . $sender_data->lname . "", "" . $fullshipment . "", "" . $status_courier_deliver . "", "" . $app_url . "");

        $receiver_body = $subjectVal_receiver->body;

        // Function to replace string
        $resStr_receiver = str_replace($searchVal_receiver, $replaceVal_receiver, $receiver_body);

        $newbodyS_receiver = $resStr_receiver;



        //NOTIFY SMS API
        if (isset($_POST['notify_sms_sender']) && $_POST['notify_sms_sender'] == 1) {


            if ($core->twilio_sms_sid != null && $core->twilio_sms_token != null && $core->twilio_sms_number != null) {


                $phone_sender = $sender_data->phone;

                // Your Account SID and Auth Token from twilio.com/console
                $account_sid = $core->twilio_sms_sid;
                $auth_token = $core->twilio_sms_token;
                // In production, these should be environment variables. E.g.:
                // $auth_token = $_ENV["TWILIO_AUTH_TOKEN"]

                // A Twilio number you own with SMS capabilities
                $twilio_numbers = $core->twilio_sms_number;

                $client = new Client($account_sid, $auth_token);
                $client->messages->create(
                    // Where to send a text message (your cell phone?)
                    '' . $phone_sender . '',
                    array(
                        'from' => $twilio_numbers,
                        'body' => htmlentities('' . $newbodyS_sender . '')
                    )
                );
            }
        }


        if (isset($_POST['notify_sms_receiver']) && $_POST['notify_sms_receiver'] == 1) {


            if ($core->twilio_sms_sid != null && $core->twilio_sms_token != null && $core->twilio_sms_number != null) {

                $phone_receiver = $receiver_data->phone;

                // Your Account SID and Auth Token from twilio.com/console
                $account_sid = $core->twilio_sms_sid;
                $auth_token = $core->twilio_sms_token;
                // In production, these should be environment variables. E.g.:
                // $auth_token = $_ENV["TWILIO_AUTH_TOKEN"]

                // A Twilio number you own with SMS capabilities
                $twilio_numbers = $core->twilio_sms_number;

                $client = new Client($account_sid, $auth_token);
                $client->messages->create(
                    // Where to send a text message (your cell phone?)
                    '' . $phone_receiver . '',
                    array(
                        'from' => $twilio_numbers,
                        'body' => htmlentities('' . $newbodyS_receiver . '')
                    )
                );
            }
        }




        header("location:consolidate_view.php?id=$id");
    }
}


?>
<!DOCTYPE html>
<html dir="ltr" lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="keywords" content="Courier DEPRIXA-Integral Web System" />
    <meta name="author" content="Jaomweb">

    <title><?php echo $lang['status-ship1011'] ?> | <?php echo $core->site_name ?></title>

    <link rel="stylesheet" type="text/css" href="assets/libs/select2/dist/css/select2.min.css">
    <?php include 'views/inc/head_scripts.php'; ?>

</head>

<body>
    <!-- ============================================================== -->
    <!-- Preloader - style you can find in spinners.css -->
    <!-- ============================================================== -->


    <?php include 'views/inc/preloader.php'; ?>
    <!-- ============================================================== -->
    <!-- Main wrapper - style you can find in pages.scss -->
    <!-- ============================================================== -->
    <div id="main-wrapper">
        <!-- ============================================================== -->
        <!-- Topbar header - style you can find in pages.scss -->
        <!-- ============================================================== -->

        <!-- ============================================================== -->
        <!-- Preloader - style you can find in spinners.css -->
        <!-- ============================================================== -->

        <?php include 'views/inc/topbar.php'; ?>

        <!-- End Topbar header -->


        <!-- Left Sidebar - style you can find in sidebar.scss  -->
        <?php $code_countries = $core->cdp_getCodeCountries(); ?>

        <?php include 'views/inc/left_sidebar.php'; ?>


        <!-- End Left Sidebar - style you can find in sidebar.scss  -->

        <!-- Page wrapper  -->
        <!-- ============================================================== -->
        <div class="page-wrapper">


            <div class="container-fluid">


                <div class="row justify-content-center">
                    <!-- Column -->
                    <div class="col-lg-12 col-xlg-12 col-md-12">
                        <div class="card">

                            <div class="card-body">
                                <!-- <div id="loader" style="display:none"></div> -->
                                <div id="resultados_ajax">
                                    <?php if (!empty($errors)) { ?>
                                        <div class="alert alert-danger" id="success-alert">
                                            <p><span class="icon-minus-sign"></span><i class="close icon-remove-circle"></i>
                                                <span>Error! </span> There was an error processing the request
                                            <ul class="error">
                                                <?php
                                                foreach ($errors as $error) { ?>
                                                    <li>
                                                        <i class="icon-double-angle-right"></i>
                                                        <?php
                                                        echo $error;

                                                        ?>

                                                    </li>
                                                <?php
                                                }
                                                ?>


                                            </ul>
                                            </p>
                                        </div>
                                    <?php
                                    } ?>

                                </div>
                                <form class="xform" id="form" name="form" method="post">
                                    <header>
                                        <h4 class="modal-title"> <b class="text-danger"><?php echo $lang['status-ship1011'] ?> </b> <b>| #<?php echo $row->c_prefix . $row->c_no; ?></b>
                                        </h4><!--  <?php echo $lang['status-ship3'] ?> <?php echo $receiver_data->country; ?> | <?php echo $receiver_data->city; ?> -->
                                        <hr>
                                    </header>


                                    <div class="row">
                                        <div class="col-sm-12 col-md-6">
                                            <h4 class="card-title mt-3"><?php echo $lang['status-ship4'] ?> </h4>
                                            <div class="input-group mb-3">

                                                <select class="select2 form-select" name="country" id="country" required="required" style="width: 100%;">
                                                    <option value="0">--<?php echo $lang['leftorder14track'] ?>--</option>
                                                    <?php foreach ($code_countries as $row) : ?>
                                                        <option value="<?php echo $row->name; ?>"><?php echo $row->name; ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-sm-12 col-md-6">
                                            <h4 class="card-title mt-3"><?php echo $lang['status-ship5'] ?></h4>
                                            <div class="input-group mb-3">
                                                <div class="input-group-prepend">
                                                    <button class="btn btn-light-info text-info" type="button">
                                                        <i data-feather="navigation" class="fill-white feather-sm"></i>
                                                    </button>
                                                </div>
                                                <input type="text" class="form-control" id="address" name="address" placeholder="Enter address" required aria-describedby="basic-addon1">
                                            </div>
                                        </div>
                                    </div>


                                    <div class="row">

                                        <div class="col-sm-12 col-md-6">
                                            <div class="form-group">
                                                <h4 class="card-title mt-3"><?php echo $lang['left423'] ?></h4>
                                                <select class="form-select" name="office" id="office" list="browsee" autocomplete="off" placeholder="--Select Office--">
                                                    <option value="0">--<?php echo $lang['left343'] ?>--</option>
                                                    <!-- <datalist id="browsee"> -->
                                                    <?php foreach ($office as $row) : ?>
                                                        <option value="<?php echo $row->id; ?>"><?php echo $row->name_off; ?></option>
                                                    <?php endforeach; ?>
                                                    <!-- </datalist> -->
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-sm-12 col-md-6">
                                            <h4 class="card-title mt-3"><?php echo $lang['status-ship9'] ?></h4>
                                            <div class="input-group mb-3">
                                                <select class="form-select" name="status_courier" placeholder="--Select Status--" required="required">
                                                    <!-- <datalist id="browserst"> -->
                                                    <option value="0">--<?php echo $lang['left1095'] ?>--</option>
                                                    <?php foreach ($statusrow as $row) : ?>
                                                        <?php if ($row->mod_style == 'Delivered') { ?>
                                                        <?php } elseif ($row->mod_style == 'Consolidate') { ?>
                                                        <?php } else { ?>
                                                            <option value="<?php echo $row->id; ?>"><?php echo $row->mod_style; ?></option>
                                                        <?php } ?>
                                                    <?php endforeach; ?>
                                                    <!-- </datalist> -->
                                                </select>
                                            </div>
                                        </div>




                                    </div>
                                    <div class="row">
                                        <div class="col-sm-12 col-md-6" style="display:none">
                                            <label for="inputEmail3" class="control-label col-form-label"><?php echo $lang['status-ship6'] ?></label>
                                            <div class="input-group mb-3">
                                                <div class="input-group-prepend">
                                                    <span class="input-group-text">
                                                        <span class="fa fa-calendar"></span>
                                                    </span>
                                                </div>
                                                <input type="text" class="form-control" name="t_date" id="t_date" data-toggle="tooltip" data-placement="bottom" title="<?php echo $lang['add-title16'] ?>" readonly value="<?php echo date('Y-m-d'); ?>">
                                            </div>
                                        </div>


                                        <div class="col-sm-12 col-md-12">
                                            <h4 class="card-title mt-3"><?php echo $lang['status-ship8'] ?></h4>
                                            <textarea rows="3" class="form-control" placeholder="Status change details...." id="message-text" name="comments"></textarea>
                                        </div>
                                        <?php
                                        if ($core->active_sms == 1) {
                                        ?>
                                            <div class="col-sm-12 col-md-6">
                                                <br>
                                                <label class="custom-control custom-checkbox" style="font-size: 18px; padding-left: 0px">
                                                    <input type="checkbox" class="custom-control-input" name="notify_sms_sender" id="notify_sms_sender" value="1">
                                                    <b>Notify sender by SMS &nbsp; <i class="fa fa-envelope" style="font-size: 18px; color:#07bc4c;"></i></b>

                                                </label>
                                                <br>
                                                <label class="custom-control custom-checkbox" style="font-size: 18px; padding-left: 0px">
                                                    <input type="checkbox" class="custom-control-input" name="notify_sms_receiver" id="notify_sms_receiver" value="1">
                                                    <b>Notify receiver by SMS <i class="fa fa-whatsapp" style="font-size: 18px; color:#07bc4c;"></i></b>

                                                </label>
                                            </div>
                                        <?php } ?>

                                    </div>

                                    </br>
                                    </br>
                                    <footer>
                                        <div class="pull-right">
                                            <a href="consolidate_list.php" class="btn btn-secondary btn-confirmation"><i class="ti-share-alt"></i> <?php echo $lang['status-ship11'] ?></a>
                                            <button class="btn btn-success" name="dosubmit" type="submit"><?php echo $lang['status-ship10'] ?></button>
                                        </div>
                                    </footer>
                                </form>
                            </div>
                        </div>

                    </div>
                    <!-- Column -->
                </div>





            </div>


        </div>

        <?php include 'views/inc/footer.php'; ?>


    </div>
    <!-- ============================================================== -->
    <!-- End Page wrapper  -->
    <!-- ============================================================== -->
    <script src="assets/libs/select2/dist/js/select2.full.min.js"></script>
    <script src="assets/libs/select2/dist/js/select2.min.js"></script>


    <script src="dataJs/consolidate_tracking.js"></script>

</body>

</html>