<?php
// *************************************************************************
// *                                                                       *
// * DEPRIXA BASIC -  Freight Forwarding & Shipping Software Solutions     *
// * Copyright (c) JAOMWEB. All Rights Reserved                            *
// *                                                                       *
// *************************************************************************
// *                                                                       *
// * Email: support@jaom.info                                              *
// * Website: https://deprixa.link/documentation/                          *
// *                                                                       *
// *************************************************************************
// *                                                                       *
// * This software is furnished under a license and may be used and copied *
// * only  in  accordance  with  the  terms  of such  license and with the *
// * inclusion of the above copyright notice.                              *
// * If you Purchased from Codecanyon, Please read the full License from   *
// * here- http://codecanyon.net/licenses/standard                         *
// *                                                                       *
// *************************************************************************

require_once('helpers/querys.php');

$userData = $user->cdp_getUserData();

if (isset($_GET['id_order'])) {
    $data = cdp_getCourierPrint($_GET['id_order']);
}


if (!isset($_GET['id_order']) or $data['rowCount'] != 1) {
    cdp_redirect_to("courier_list.php");
}

$row_order = $data['data'];

$userData = $user->cdp_getUserData();

$track_order = $row_order->order_prefix . $row_order->order_no;


$payrow = $core->cdp_getPayment();

?>



<!DOCTYPE html>
<html dir="ltr" lang="en"> 

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="keywords" content="Courier DEPRIXA-Integral Web System" />
    <meta name="author" content="Jaomweb">

    <title><?php echo $lang['leftorder131'] ?> | <?php echo $core->site_name ?></title>
    <?php include 'views/inc/head_scripts.php'; ?>

    <script src="https://js.stripe.com/v3/"></script>
    <script src="https://polyfill.io/v3/polyfill.min.js?version=3.52.1&features=fetch"></script>

    <script src="https://www.paypal.com/sdk/js?client-id=<?php echo $core->paypal_client_id; ?>&currency=USD&disable-funding=credit,card"></script>

    <script src="https://js.paystack.co/v1/inline.js"></script>

</head>

<body>


    <div id="main-wrapper">
        <!-- ============================================================== -->
        <!-- Preloader - style you can find in spinners.css -->
        <!-- ============================================================== -->

        <?php include 'views/inc/preloader.php'; ?>

        <!-- ============================================================== -->
        <!-- Preloader - style you can find in spinners.css -->
        <!-- ============================================================== -->

        <?php include 'views/inc/topbar.php'; ?>

        <!-- End Topbar header -->


        <!-- Left Sidebar - style you can find in sidebar.scss  -->

        <?php include 'views/inc/left_sidebar.php'; ?>


        <!-- End Left Sidebar - style you can find in sidebar.scss  -->

        <!-- Page wrapper  -->

        <div class="page-wrapper">

            <!-- ============================================================== -->
            <!-- Container fluid  -->
            <!-- ============================================================== -->
            <div class="container-fluid">

                <div class="row">
                    <div id="resultados_ajax"></div>

                    <div class="col-lg-12">
                        <div class="card">
                            <div class="border-bottom title-part-padding">
                                <h4 class="card-title mb-0"><b class="text-danger"><?php echo $lang['inv-container4'] ?></b> <span>#<?php echo $row_order->order_prefix . $row_order->order_no; ?></span></h4>
                            </div>

                            <div class="card-body">
                                <div class="col-lg-12 mx-auto text-left mb-3">

                                    <h3 class="card-title mb-0"><?php echo $lang['leftorder132'] ?>: <b><?php echo  number_format($row_order->total_order, 2, '.', ''); ?> <?php echo $core->currency; ?> </b></h3>
                                    <div><br></div>
                                    <ul class="nav nav-tabs" role="tablist">

                                        <li role="presentation" class="nav-item">
                                            <?php if ($core->active_stripe == 1) { ?>
                                                <a href="#stripe" class="nav-link active" aria-controls="home" role="tab" data-bs-toggle="tab" aria-expanded="true">
                                                    <span class="visible-xs"><i class="far fa-credit-card mr-2"></i> Stripe</span><span class="hidden-xs">
                                                </a>
                                            <?php } ?>
                                        </li>

                                        <li role="presentation" class="nav-item">
                                            <?php if ($core->active_paypal == 1) { ?>
                                                <a href="#paypal" class="nav-link" aria-controls="home" role="tab" data-bs-toggle="tab" aria-expanded="true">
                                                    <span class="visible-xs"><i class="fab fa-paypal mr-2"></i> Paypal</span><span class="hidden-xs">
                                                </a>
                                            <?php } ?>
                                            </a>
                                        </li>

                                        <li role="presentation" class="nav-item">
                                            <?php if ($core->active_paystack == 1) { ?>
                                                <a href="#paystack" class="nav-link" aria-controls="home" role="tab" data-bs-toggle="tab" aria-expanded="true">
                                                    <span class="visible-xs"><i class="far fa-credit-card mr-2"></i> Paystack</span><span class="hidden-xs">
                                                </a>
                                            <?php } ?>
                                            </a>
                                        </li>

                                        <li role="presentation" class="nav-item">
                                            <?php if ($core->active_attach_proof == 1) { ?>
                                                <a href="#attach" class="nav-link" aria-controls="home" role="tab" data-bs-toggle="tab" aria-expanded="true">
                                                    <span class="visible-xs"><i class="fa fa-paperclip mr-2"></i> <?php echo $lang['leftorder133'] ?></span><span class="hidden-xs">
                                                </a>
                                            <?php } ?>
                                            </a>
                                        </li>
                                    </ul>

                                    <div class="tab-content mb-3">
                                        <div><br><br><br></div>
                                        <div role="tabpanel" class="tab-pane" id="paypal">
                                            <div class="row">
                                                <div class="col-md-7">
                                                    <?php if ($core->active_paypal == 1) { ?>

                                                        <!-- PAYPAL TAB-PANE -->
                                                        <div id="paypal">

                                                            <p class="text-center text-info"> <b><?php echo $lang['leftorder134'] ?>.</b></p>
                                                            <div id="paypal-button-container" class=" text-center col-md-12"></div>

                                                        </div>
                                                        <!-- END  PAYPAL TAB-PANE -->

                                                    <?php } ?>

                                                </div>

                                                <div class="col-md-4 ms-auto">
                                                    <h4 class="card-title mt-4"><?php echo $lang['leftorder135'] ?></h4>
                                                    <h2><img src="assets/images/payment/paypal-payment.png" alt="Stripe" width="282" height="81"></h2>

                                                </div>
                                            </div>
                                        </div>

                                        <div role="tabpanel" class="tab-pane" id="paystack">
                                            <div class="row">
                                                <div class="col-md-7">
                                                    <?php if ($core->active_paystack == 1) { ?>

                                                        <!-- PAYSTACK TAB-PANE -->
                                                        <div id="paystack">

                                                            <form id="paymentForm">

                                                                <div class="col-xs-12 col-md-12">
                                                                    <div class="mb-3">
                                                                        <label><?php echo $lang['langs_01050'] ?></label>
                                                                        <input class="form-control" type="email" id="email-address" required>
                                                                    </div>
                                                                </div>

                                                                <div class="col-xs-12 col-md-12">
                                                                    <div class="mb-3">
                                                                        <label><?php echo $lang['user-account5'] ?></label>
                                                                        <input class="form-control" type="text" id="first-name" required>
                                                                    </div>
                                                                </div>

                                                                <div class="col-xs-12 col-md-12">
                                                                    <div class="mb-3">
                                                                        <label><?php echo $lang['user-account6'] ?></label>
                                                                        <input class="form-control" type="text" id="last-name" required>
                                                                    </div>
                                                                </div>

                                                                <div class="form-submit mb-3">
                                                                    <button class="btn btn-info" type="submit"><?php echo $lang['leftorder136'] ?></button>
                                                                </div>
                                                            </form>


                                                        </div>
                                                        <!-- END PAYSTACK TAB-PANE -->

                                                    <?php } ?>

                                                </div>

                                                <div class="col-md-4 ms-auto">
                                                    <h4 class="card-title mt-4"><?php echo $lang['leftorder137'] ?></h4>
                                                    <h2><img src="assets/images/payment/paystack-payment.png" alt="Stripe" width="236" height="81"></h2>

                                                </div>
                                            </div>
                                        </div>

                                        <div role="tabpanel" class="tab-pane" id="attach">
                                            <div class="row">
                                                <div class="col-md-7">
                                                    <?php if ($core->active_attach_proof == 1) { ?>

                                                        <!-- ATTACH TAB-PANE -->
                                                        <div id="attach">

                                                            <form class="form-horizontal" method="post" id="add_charges" name="add_charges">

                                                                <p class=""> <b><?php echo $lang['leftorder138'] ?>.</b></p>
                                                                <div class="row">

                                                                    <div class="form-group col-md-12">
                                                                        <label for="inputEmail3" class="control-label col-form-label"><?php echo $lang['left243'] ?></label>
                                                                        <div class="input-group mb-3">
                                                                            <select class="form-select col-12" id="mode_pay" name="mode_pay" required="">
                                                                                <option value=""><?php echo $lang['left243'] ?></option>
                                                                                <?php foreach ($payrow as $row) : ?>
                                                                                    <option value="<?php echo $row->id; ?>"><?php echo $row->met_payment; ?></option>
                                                                                <?php endforeach; ?>
                                                                            </select>
                                                                        </div>
                                                                    </div>

                                                                </div>

                                                                <div class="row mb-3">

                                                                    <div class="col-md-6">

                                                                        <div>
                                                                            <label class="control-label" id="selectItem"> <?php echo $lang['leftorder15'] ?></label>
                                                                        </div>

                                                                        <input class="custom-file-input" id="filesMultiple" name="filesMultiple" type="file" style="display: none;" onchange="cdp_validateZiseFiles();" />


                                                                        <button type="button" id="openMultiFile" class="btn btn-info  pull-left "> <i class='fa fa-paperclip' id="openMultiFile" style="font-size:18px; cursor:pointer;"></i> <?php echo $lang['leftorder46'] ?></button>

                                                                        <div id="clean_files" class="row hide">
                                                                            <button type="button" id="clean_file_button" class="  mt-3 btn btn-danger ml-3"> <i class='fa fa-trash' style="font-size:18px; cursor:pointer;"></i> <?php echo $lang['leftorder17'] ?> </button>

                                                                        </div>

                                                                    </div>


                                                                </div>


                                                                <div class="row">
                                                                    <div class="form-group col-sm-12">
                                                                        <label for="notes" class="control-label"><?php echo $lang['leftorder49'] ?></label>

                                                                        <textarea class="form-control" id="notes" name="notes" rows="2"></textarea>
                                                                    </div>
                                                                </div>

                                                                <div class="modal-footer">

                                                                    <button type="submit" class="btn btn-success" id="save_form2"><?php echo $lang['left1103'] ?></button>
                                                                </div>
                                                            </form>


                                                        </div> <!-- END  ATTACH TAB-PANE -->

                                                    <?php } ?>

                                                </div>
                                            </div>
                                        </div>

                                        <div role="tabpanel" class="tab-pane active" id="stripe">
                                            <div class="row">
                                                <div class="col-md-7">

                                                    <!-- STRIPE TAB-PANE -->
                                                    <?php if ($core->active_stripe == 1) { ?>

                                                        <form id="payment-form">

                                                            <div class="col-xs-12 col-md-12">
                                                                <div class="mb-3">
                                                                    <label><?php echo $lang['left1104'] ?></label>
                                                                    <input class="form-control" type="text" name="name_property_card_stripe" id="name_property_card_stripe" required>
                                                                </div>
                                                            </div>

                                                            <input type="hidden" name="order_id" id="order_id" value="<?php echo $_GET['id_order']; ?>">

                                                            <input type="hidden" name="track_order" id="track_order" value="<?php echo $track_order; ?>">

                                                            <div class="col-xs-12 col-md-12">
                                                                <div class="mb-3">
                                                                    <label><?php echo $lang['left1106'] ?></label>
                                                                    <input class="form-control" type="email" name="email_property_card_stripe" id="email_property_card_stripe" required>
                                                                </div>
                                                            </div>

                                                            <div class="col-xs-12 col-md-12">
                                                                <div class="mb-3">
                                                                    <div id="card-element" class="form-control" style="margin-top: 20px; margin-bottom: 30px">
                                                                        <!--Stripe.js injects the Card Element-->
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <button class="btn btn-info" id="submit">
                                                                <div class="spinner hidden" id="spinner"></div>
                                                                <span id="button-text"><?php echo $lang['leftorder136'] ?></span>
                                                            </button>
                                                            <p id="card-error-custom" class="text-danger" role="alert"></p>

                                                        </form>
                                                        <!-- END STRIPE TAB-PANE -->
                                                    <?php } ?>
                                                </div>

                                                <div class="col-md-4 ms-auto">
                                                    <h4 class="card-title mt-4"><?php echo $lang['leftorder139'] ?></h4>
                                                    <h2><img src="assets/images/payment/stripe-payment.png" alt="Stripe" width="332" height="47"></h2>

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                        </div>

                    </div>
                </div>



                <input id="active_paypal" name="active_paypal" type="hidden" value="<?php echo $core->active_paypal; ?>" />
                <input id="active_stripe" name="active_stripe" type="hidden" value="<?php echo $core->active_stripe; ?>" />
                <input id="active_paystack" name="active_paystack" type="hidden" value="<?php echo $core->active_paystack; ?>" />


                <input id="order_total_order" name="order_total_order" type="hidden" value="<?php echo  number_format($row_order->total_order, 2, '.', ''); ?>" />
                <input id="track_order" name="track_order" type="hidden" value="<?php echo $track_order; ?>" />
                <input id="order_id" name="order_id" type="hidden" value="<?php echo $row_order->order_id; ?>" />

                <input id="order_sender_id" name="order_sender_id" type="hidden" value="<?php echo  $row_order->sender_id; ?>" />
                <input id="public_key_stripe" name="public_key_stripe" type="hidden" value="<?php echo $core->public_key_stripe; ?>" />
                <input id="public_key_paystack" name="public_key_paystack" type="hidden" value="<?php echo $core->public_key_paystack; ?>" />

            </div>
        </div>

        <?php include 'views/inc/footer.php'; ?>

    </div>
    <!-- ============================================================== -->
    <!-- End Page wrapper  -->
    <!-- ============================================================== -->

    <script src="dataJs/courier_add_payment_gateways.js"></script>


</body>

</html>