<?php
// *************************************************************************
// *                                                                       *
// * DEPRIXA BASIC -  Freight Forwarding & Shipping Software Solutions     *
// * Copyright (c) JAOMWEB. All Rights Reserved                            *
// *                                                                       *
// *************************************************************************
// *                                                                       *
// * Email: support@jaom.info                                              *
// * Website: https://deprixa.link/documentation/                          *
// *                                                                       *
// *************************************************************************
// *                                                                       *
// * This software is furnished under a license and may be used and copied *
// * only  in  accordance  with  the  terms  of such  license and with the *
// * inclusion of the above copyright notice.                              *
// * If you Purchased from Codecanyon, Please read the full License from   *
// * here- http://codecanyon.net/licenses/standard                         *
// *                                                                       *
// *************************************************************************


$userData = $user->cdp_getUserData();

$db = new Conexion;

?>
<!DOCTYPE html>
<html dir="ltr" lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <!-- Tell the browser to be responsive to screen width -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="keywords" content="Courier DEPRIXA-Integral Web System" />
    <meta name="author" content="Jaomweb">
    <title><?php echo $lang['leftorder183'] ?> | <?php echo $core->site_name ?></title>

    <!-- Favicon icon -->
    <link rel="icon" type="image/png" sizes="16x16" href="assets/<?php echo $core->favicon ?>">

    <?php include 'views/inc/head_scripts.php'; ?>
</head>

<body>

    <div id="main-wrapper">
        <!-- ============================================================== -->
        <!-- Preloader - style you can find in spinners.css -->
        <!-- ============================================================== -->

        <?php include 'views/inc/preloader.php'; ?>

        <!-- ============================================================== -->
        <!-- Preloader - style you can find in spinners.css -->
        <!-- ============================================================== -->

        <?php include 'views/inc/topbar.php'; ?>

        <!-- End Topbar header -->


        <!-- Left Sidebar - style you can find in sidebar.scss  -->

        <?php include 'views/inc/left_sidebar.php'; ?>


        <!-- End Left Sidebar - style you can find in sidebar.scss  -->

        <!-- Page wrapper  -->

        <div class="page-wrapper">
            <!-- -------------------------------------------------------------- -->
            <!-- Bread crumb and right sidebar toggle -->
            <!-- -------------------------------------------------------------- -->
            <div class="page-breadcrumb">
                <div class="row">
                    <div class="col-5 align-self-center">
                        <h4 class="page-title"><?php echo $lang['leftorder183'] ?></h4>
                    </div>
                </div>
            </div>
            <!-- -------------------------------------------------------------- -->
            <!-- End Bread crumb and right sidebar toggle -->
            <!-- -------------------------------------------------------------- -->
            <!-- -------------------------------------------------------------- -->
            <!-- Container fluid  -->
            <!-- -------------------------------------------------------------- -->
            <div class="container-fluid">
                <!-- -------------------------------------------------------------- -->
                <!-- Overview, Visits, Sales, Order -->
                <!-- -------------------------------------------------------------- -->
                <div class="row">
                    <!-- column -->
                    <div class="col-sm-12 col-lg-6 d-flex align-items-stretch">
                        <!-- ---------------------
                            start Last Month Summary
                        ---------------- -->
                        <div class="card w-100">
                            <div class="card-body">

                                <div class="d-md-flex align-items-center">
                                    <div>
                                        <h4 class="card-title"><?php echo $lang['dashnew06'] ?></h4>
                                        <h5 class="card-subtitle"><?php echo $lang['leftorder123'] ?></h5>
                                    </div>
                                </div>

                                <div class="row">
                                    <!-- col shipments-->
                                    <div class="col-lg-4 col-md-4 border-end">
                                        <div class="d-flex align-items-center">
                                            <div class="me-2">
                                                <a href="#">
                                                    <span class="text-transit display-6">
                                                        <i data-feather="box" class="feather-xl"></i>
                                                    </span>
                                                </a>
                                            </div>
                                            <div><span><?php echo $lang['dashnew07'] ?></span>
                                                <h3 class="font-medium m-b-0">
                                                    <?php

                                                    $db->cdp_query("SELECT COUNT(*) as total FROM cdb_add_order WHERE is_pickup=0 and driver_id='" . $_SESSION['userid'] . "'");

                                                    $db->cdp_execute();

                                                    $count = $db->cdp_registro();

                                                    echo $count->total;
                                                    ?>
                                                </h3>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- end col shipment -->


                                    <!-- col shipment delivered -->
                                    <div class="col-lg-4 col-md-4 border-end">
                                        <div class="d-flex align-items-center">
                                            <div class="me-2">
                                                <a href="#">
                                                    <span class="text-delivered display-6">
                                                        <i data-feather="package" class="feather-xl"></i>
                                                    </span>
                                                </a>
                                            </div>
                                            <div><span><?php echo $lang['leftorder126'] ?></span>
                                                <h3 class="font-medium m-b-0">
                                                    <?php

                                                    $db->cdp_query("SELECT COUNT(*) as total FROM cdb_add_order WHERE status_courier=8 and is_pickup=0 and driver_id='" . $_SESSION['userid'] . "'");

                                                    $db->cdp_execute();

                                                    $count = $db->cdp_registro();

                                                    echo $count->total;
                                                    ?>
                                                </h3>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- End col shipment delivered -->


                                    <!-- col consolidate -->
                                    <div class="col-lg-4 col-md-4">
                                        <div class="d-flex align-items-center">
                                            <div class="me-2">
                                                <a href="consolidate_list.php">
                                                    <span class="text-primary display-6">
                                                        <i data-feather="gift" class="feather-xl"></i>
                                                    </span>
                                                </a>
                                            </div>
                                            <div><span><?php echo $lang['leftorder130'] ?></span>
                                                <h3 class="font-medium m-b-0">
                                                    <?php

                                                    $db->cdp_query("SELECT COUNT(*) as total FROM cdb_consolidate WHERE driver_id='" . $_SESSION['userid'] . "'");

                                                    $db->cdp_execute();

                                                    $count = $db->cdp_registro();

                                                    echo $count->total;
                                                    ?>
                                                </h3>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- End col consolidate -->
                                </div>


                            </div>

                        </div>
                        <!-- ---------------------
                            end Last Month Summary
                        ---------------- -->
                    </div>


                    <!-- column -->
                    <div class="col-sm-12 col-lg-6 d-flex align-items-stretch">

                        <div class="card w-100">
                            <div class="card-body">
                                <div class="d-flex align-items-center mb-4">
                                    <div>
                                        <h4 class="card-title"><?php echo $lang['leftorder108'] ?></h4>
                                        <h5 class="card-subtitle"><?php echo $lang['leftorder123'] ?></h5>
                                    </div>

                                </div>

                                <div class="row">

                                    <div class="col-sm-12 col-md-6 col-lg-6">
                                        <ul class="list-style-none">

                                            <li class="m-t-30">
                                                <div class="d-flex align-items-center">
                                                    <div>
                                                        <span class="text-muted"><?php echo $lang['leftorder184'] ?></span>
                                                        <h4 class="m-b-0">
                                                            <span class="font-16">
                                                                <?php

                                                                $db->cdp_query("SELECT IFNULL(SUM(total_order),0) as total FROM cdb_add_order where is_pickup=0 and driver_id='" . $_SESSION['userid'] . "'");

                                                                $db->cdp_execute();

                                                                $count = $db->cdp_registro();

                                                                echo $core->currency . ' ' . number_format($count->total, 2, '.', '.');

                                                                ?>
                                                            </span>
                                                        </h4>
                                                    </div>
                                                </div>

                                                <div class="progress" style="height: 7px;">
                                                    <div class="progress-bar progress-bar-striped bg-info progress-bar-animated" role="progressbar" aria-valuenow="47" aria-valuemin="0" aria-valuemax="100" style="width: <?php echo number_format($count->total, 2, '.', '.') / 100; ?>%"></div>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>

                                    <div class="col-sm-12 col-md-6 col-lg-6">
                                        <ul class="list-style-none">

                                            <li class="m-t-30">
                                                <div class="d-flex align-items-center">
                                                    <div>
                                                        <span class="text-muted"><?php echo $lang['left1011'] ?></span>
                                                        <h4 class="m-b-0">
                                                            <span class="font-16">
                                                                <?php

                                                                $db->cdp_query("SELECT IFNULL(SUM(total_order),0) as total FROM cdb_consolidate where driver_id='" . $_SESSION['userid'] . "'");

                                                                $db->cdp_execute();

                                                                $count = $db->cdp_registro();

                                                                echo $core->currency . ' ' . number_format($count->total, 2, '.', '.');

                                                                ?>
                                                            </span>
                                                        </h4>
                                                    </div>
                                                </div>
                                                <div class="progress" style="height: 7px;">
                                                    <div class="progress-bar progress-bar-striped bg-success progress-bar-animated" role="progressbar" aria-valuenow="47" aria-valuemin="0" aria-valuemax="100" style="width: <?php echo number_format($count->total, 2, '.', '.') / 100; ?>%"></div>
                                                </div>
                                            </li>

                                        </ul>
                                    </div>

                                </div>

                            </div>
                        </div>
                    </div>
                </div>

                <!-- -------------------------------------------------------------- -->
                <!-- Table -->
                <!-- -------------------------------------------------------------- -->


                <div class="row">
                    <!-- Column -->

                    <div class="col-lg-12 col-xl-12 col-md-12">

                        <div class="card">
                            <div class="card-body">
                                <div class="d-md-flex align-items-center">
                                    <div>
                                        <h4 class="card-title"><?php echo $lang['dashnew19'] ?></h4>
                                        <input type="hidden" name="userid" id="userid" value="<?php echo $_SESSION['userid']; ?>">
                                    </div>
                                </div>

                                <div class="tab-content" id="pills-tabContent">
                                    <div class="tab-pane fade show active" id="pills-shipment" role="tabpanel" aria-labelledby="pills-home-tab">
                                        <div class="row">
                                            <!-- column -->
                                            <div class="col-sm-6 col-md-6">
                                                <ul class="nav nav-pills mb-3" id="pills-tab" role="tablist">
                                                    <li class="nav-item">
                                                        <div class="form-group">
                                                            <a href="courier_add.php"><button type="button" class="btn waves-effect waves-light btn-light-success text-success "><i class="mdi mdi-package-variant-closed" aria-hidden="true"></i> <?php echo $lang['createnewshiporder'] ?></button></a>
                                                        </div>
                                                    </li>

                                                </ul>
                                            </div>

                                            <!-- column -->
                                            <div class="col-sm-6 col-md-6 ">

                                                <div class="input-group">
                                                    <input type="text" name="search" id="search" class="form-control input-sm float-right" placeholder="search tracking" onkeyup="cdp_load(1);">
                                                    <div class="input-group-append input-sm">
                                                        <button type="submit" class="btn btn-info"><i class="fa fa-search"></i></button>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                        <div>
                                            <hr>
                                        </div>

                                        <div class="outer_div"></div>
                                    </div>

                                </div>

                            </div>
                        </div>
                    </div>
                    <!-- Column -->
                </div>
                <!-- -------------------------------------------------------------- -->
                <!-- Table -->
                <!-- -------------------------------------------------------------- -->

            </div>
            <!-- -------------------------------------------------------------- -->
            <!-- End Container fluid  -->
            <!-- -------------------------------------------------------------- -->



            <?php include 'views/inc/footer.php'; ?>
        </div>
    </div>

    <script src="dataJs/dashboard_driver.js"></script>
    <script src="dataJs/courier.js"></script>


</body>

</html>