<?php
// *************************************************************************
// *                                                                       *
// * DEPRIXA BASIC -  Freight Forwarding & Shipping Software Solutions     *
// * Copyright (c) JAOMWEB. All Rights Reserved                            *
// *                                                                       *
// *************************************************************************
// *                                                                       *
// * Email: support@jaom.info                                              *
// * Website: https://deprixa.link/documentation/                          *
// *                                                                       *
// *************************************************************************
// *                                                                       *
// * This software is furnished under a license and may be used and copied *
// * only  in  accordance  with  the  terms  of such  license and with the *
// * inclusion of the above copyright notice.                              *
// * If you Purchased from Codecanyon, Please read the full License from   *
// * here- http://codecanyon.net/licenses/standard                         *
// *                                                                       *
// *************************************************************************


$userData = $user->cdp_getUserData();

$db = new Conexion;

?>
<!DOCTYPE html>
<html dir="ltr" lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <!-- Tell the browser to be responsive to screen width -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="keywords" content="Courier DEPRIXA-Integral Web System" />
    <meta name="author" content="Jaomweb">
    <title>Dashboard | <?php echo $core->site_name ?></title>

    <?php include 'views/inc/head_scripts.php'; ?>

    <link rel="stylesheet" href="assets/libs/apexcharts/dist/apexcharts.css">
</head>

<body>

    <div id="main-wrapper">
        <!-- ============================================================== -->
        <!-- Preloader - style you can find in spinners.css -->
        <!-- ============================================================== -->

        <?php include 'views/inc/preloader.php'; ?>

        <!-- ============================================================== -->
        <!-- Preloader - style you can find in spinners.css -->
        <!-- ============================================================== -->

        <?php include 'views/inc/topbar.php'; ?>

        <!-- End Topbar header -->


        <!-- Left Sidebar - style you can find in sidebar.scss  -->

        <?php include 'views/inc/left_sidebar.php'; ?>


        <!-- End Left Sidebar - style you can find in sidebar.scss  -->

        <!-- Page wrapper  -->

        <div class="page-wrapper">
            <!-- -------------------------------------------------------------- -->
            <!-- Bread crumb and right sidebar toggle -->
            <!-- -------------------------------------------------------------- -->
            <div class="page-breadcrumb">
                <div class="row">
                    <div class="col-5 align-self-center">
                        <h4 class="page-title">Dashboard</h4>
                    </div>
                </div>
            </div>
            <!-- -------------------------------------------------------------- -->
            <!-- End Bread crumb and right sidebar toggle -->
            <!-- -------------------------------------------------------------- -->
            <!-- -------------------------------------------------------------- -->
            <!-- Container fluid  -->
            <!-- -------------------------------------------------------------- -->
            <div class="container-fluid">
                <!-- -------------------------------------------------------------- -->
                <!-- Overview, Visits, Sales, Order -->
                <!-- -------------------------------------------------------------- -->
                <div class="row">
                    <!-- column -->
                    <div class="col-sm-12 col-lg-6 d-flex align-items-stretch">
                        <!-- ---------------------
                            start Last Month Summary
                        ---------------- -->
                        <div class="card w-100">
                            <div class="card-body">

                                <div class="d-md-flex align-items-center">
                                    <div>
                                        <h4 class="card-title"><?php echo $lang['dashnew06'] ?></h4>
                                        <h5 class="card-subtitle"><?php echo $lang['leftorder95'] ?></h5>
                                    </div>
                                </div>

                                <div class="row">
                                    <!-- col shipments-->
                                    <div class="col-lg-4 col-md-4 border-end">
                                        <div class="d-flex align-items-center">
                                            <div class="me-2">
                                                <a href="courier_list.php">
                                                    <span class="text-warning display-6">
                                                        <i data-feather="box" class="feather-xl"></i>
                                                    </span>
                                                </a>
                                            </div>
                                            <div><span><?php echo $lang['dashnew07'] ?></span>
                                                <h3 class="font-medium m-b-0">
                                                    <?php

                                                    $db->cdp_query('SELECT COUNT(*) as total FROM cdb_add_order WHERE is_pickup=0 AND status_courier!=21');

                                                    $db->cdp_execute();

                                                    $count = $db->cdp_registro();

                                                    echo $count->total;
                                                    ?>
                                                </h3>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- end col shipment -->


                                    <!-- col consolidate -->
                                    <div class="col-lg-3 col-md-4 border-end">
                                        <div class="d-flex align-items-center">
                                            <div class="me-2">
                                                <a href="consolidate_list.php">
                                                    <span class="text-danger display-6">
                                                        <i data-feather="gift" class="feather-xl"></i>
                                                    </span>
                                                </a>
                                            </div>
                                            <div><span><?php echo $lang['dashnew09'] ?></span>
                                                <h3 class="font-medium m-b-0">
                                                    <?php

                                                    $db->cdp_query('SELECT COUNT(*) as total FROM cdb_consolidate WHERE status_courier!=21');

                                                    $db->cdp_execute();

                                                    $count = $db->cdp_registro();

                                                    echo $count->total;
                                                    ?>
                                                </h3>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- End col consolidate -->

                                    <!-- col accounts receivable-->
                                    <div class="col-lg-4 col-md-4">
                                        <div class="d-flex align-items-center">
                                            <div class="me-2">
                                                <a href="accounts_receivable.php">
                                                    <span class="text-primary display-6">
                                                        <i class="mdi mdi-package-down"></i>
                                                    </span>
                                                </a>
                                            </div>
                                            <div><span><?php echo $lang['dashnew10'] ?></span>
                                                <h3 class="font-medium m-b-0">
                                                    <?php

                                                    $db->cdp_query('SELECT COUNT(*) as total FROM cdb_add_order WHERE order_payment_method >1 AND status_courier!=21 and is_consolidate!=1');

                                                    $db->cdp_execute();

                                                    $count = $db->cdp_registro();

                                                    echo $count->total;
                                                    ?>
                                                </h3>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- End col accounts receivable -->
                                </div>

                                <div><br></div>

                                <div class="row">
                                    <!-- col -->
                                    <div class="col-lg-4 col-md-4 mb-4 mb-lg-0 border-end">
                                        <div class="d-flex align-items-center">
                                            <div class="me-2">
                                                <span class="text-orange display-6">
                                                    <i class="ri-wallet-2-fill"></i>
                                                </span>
                                            </div>
                                            <div><span><?php echo $lang['dashnew16'] ?></span>
                                                <h4 class="font-medium mb-0">
                                                    <?php echo $core->currency; ?>
                                                    <?php

                                                    $db->cdp_query('SELECT IFNULL(SUM(total_order),0) as total FROM cdb_add_order where status_courier!=21 and is_consolidate!=1 and is_pickup=0');

                                                    $db->cdp_execute();

                                                    $count = $db->cdp_registro();

                                                    echo number_format($count->total, 2, '.', '.');

                                                    ?>

                                                </h4>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- col -->

                                    <!-- col -->
                                    <div class="col-lg-6 col-md-6 mb-4 mb-md-0">
                                        <div class="d-flex align-items-center">
                                            <div class="me-2">
                                                <span class="text-danger display-6">
                                                    <i data-feather="gift" class="feather-xl"></i>
                                                </span>
                                            </div>
                                            <div><span><?php echo $lang['dashnew18'] ?></span>
                                                <h4 class="font-medium mb-0">

                                                    <?php echo $core->currency; ?>
                                                    <?php

                                                    $db->cdp_query('SELECT IFNULL(SUM(total_order),0) as total FROM cdb_consolidate WHERE status_courier!=21');

                                                    $db->cdp_execute();

                                                    $count = $db->cdp_registro();

                                                    echo number_format($count->total, 2, '.', '.');

                                                    ?>
                                                </h4>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- col -->

                                </div>
                            </div>

                            <!-- -------------------------------------------------------------- -->
                            <!-- Wallet  Summary-->
                            <!-- -------------------------------------------------------------- -->
                            <div class="card-body border-top">
                                <div class="row mb-0">
                                    <!-- col -->

                                    <?php if ($userData->userlevel == 9) { ?>
                                        <div class="col-lg-3 col-md-3 mb-4 mb-md-0">
                                            <div class="d-flex align-items-center">
                                                <div class="m-r-10"><a href="users_list.php"><span class="display-5"><i class="mdi mdi-account-settings-variant" style="color: #36bea6;"></i></span></a></div>
                                                <div>
                                                    <span class="text-muted"><?php echo $lang['dashnew02'] ?></span>
                                                    <h3 class="font-medium m-b-0">
                                                        <?php

                                                        $db->cdp_query('SELECT COUNT(*) as total FROM cdb_users WHERE userlevel=9');

                                                        $db->cdp_execute();

                                                        $count = $db->cdp_registro();

                                                        echo $count->total;
                                                        ?>
                                                    </h3>
                                                </div>

                                            </div>
                                        </div>
                                        <!-- col -->

                                        <div class="col-lg-3 col-md-3 mb-4 mb-md-0">
                                            <div class="d-flex align-items-center">
                                                <div class="m-r-10"><a href="users_list.php"><span class="display-5"><i class="mdi mdi-account-settings" style="color: #fb8c00;"></i></span></a></div>
                                                <div><span class="text-muted"><?php echo $lang['dashnew03'] ?></span>
                                                    <h3 class="font-medium m-b-0">
                                                        <?php

                                                        $db->cdp_query('SELECT COUNT(*) as total FROM cdb_users WHERE userlevel=2');

                                                        $db->cdp_execute();

                                                        $count = $db->cdp_registro();

                                                        echo $count->total;
                                                        ?>
                                                    </h3>
                                                </div>
                                            </div>
                                        </div>
                                    <?php } ?>


                                    <div class="col-lg-3 col-md-3 mb-4 mb-md-0">
                                        <div class="d-flex align-items-center">
                                            <div class="m-r-10"><a href="drivers_list.php"><span class="display-5"><i class="mdi mdi-account-star-variant" style="color: #7460ee;"></i></span></a></div>
                                            <div><span class="text-muted"><?php echo $lang['dashnew04'] ?></span>
                                                <h3 class="font-medium m-b-0">
                                                    <?php

                                                    $db->cdp_query('SELECT COUNT(*) as total FROM cdb_users WHERE userlevel=3');

                                                    $db->cdp_execute();

                                                    $count = $db->cdp_registro();

                                                    echo $count->total;
                                                    ?>
                                                </h3>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-lg-3 col-md-3 mb-4 mb-md-0">
                                        <div class="d-flex align-items-center">
                                            <div class="m-r-10"><a href="customers_list.php"><span class="display-5"><i class="mdi mdi-account-check" style="color: #1f95ff;"></i></span></a></div>
                                            <div><span class="text-muted"><?php echo $lang['dashnew05'] ?></span>
                                                <h3 class="font-medium m-b-0">
                                                    <?php

                                                    $db->cdp_query('SELECT COUNT(*) as total FROM cdb_users WHERE userlevel=1');

                                                    $db->cdp_execute();

                                                    $count = $db->cdp_registro();

                                                    echo $count->total;
                                                    ?>
                                                </h3>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- col -->
                                </div>
                            </div>
                        </div>
                        <!-- ---------------------
                            end Last Month Summary
                        ---------------- -->

                    </div>


                    <!-- column -->
                    <div class="col-sm-12 col-lg-6 ">
                        <div class="row">
                            <!-- column -->
                            <div class="col-sm-12 col-md-6 ">
                                <!-- ---------------------
                                    start Total Visits
                                ---------------- -->
                                <div class="card w-100">
                                    <div class="card-body">
                                        <h4 class="card-title"><?php echo $lang['dashnew16'] ?></h4>

                                        <h4 class="fw-bold mt-3 mb-2"><?php echo $core->currency; ?>

                                            <?php

                                            $db->cdp_query('SELECT IFNULL(SUM(total_order),0) as total FROM cdb_add_order WHERE status_courier!=21 and is_consolidate!=1');

                                            $db->cdp_execute();

                                            $count = $db->cdp_registro();

                                            echo number_format($count->total, 2, '.', '.');

                                            ?>


                                        </h4>

                                        <h5 class="card-subtitle mb-0"><?php echo $lang['left1009'] ?></h5>
                                    </div>
                                    <div class="text-center">

                                        <div id="bouncerate"></div>
                                    </div>
                                </div>
                                <!-- ---------------------
                                    end Total Visits
                                ---------------- -->
                            </div>
                            <!-- column -->
                            <div class="col-sm-12 col-md-6 ">
                                <!-- ---------------------
                                    start Sales Ratio
                                ---------------- -->
                                <div class="card">
                                    <div class="card-body">
                                        <h4 class="card-title"><a href="accounts_receivable.php"><?php echo $lang['dashnew14'] ?></a></h4>
                                        <h4 class="fw-bold mt-3 mb-2">
                                            <a href="accounts_receivable.php">

                                                <?php echo $core->currency; ?>
                                                <?php

                                                $db->cdp_query('SELECT IFNULL(SUM(total_order),0) as total FROM cdb_add_order where status_courier!=21 and is_consolidate!=1 and status_invoice!=0 and order_payment_method>1');

                                                $db->cdp_execute();

                                                $count = $db->cdp_registro();

                                                echo number_format($count->total, 2, '.', '.');
                                                ?>

                                            </a>
                                        </h4>
                                        <h5 class="card-subtitle mb-0"><?php echo $lang['left1009'] ?></h5>
                                    </div>
                                    <div class="text-center">
                                        <div class="sales-ratio"></div>
                                    </div>
                                </div>
                                <!-- ---------------------
                                    end Sales Ratio
                                ---------------- -->
                            </div>
                            <!-- column -->
                            <div class="col-sm-12 d-flex align-items-stretch">
                                <!-- ---------------------
                                    start Order Status
                                ---------------- -->
                                <div class="card order-widget w-100">
                                    <div class="card-body">
                                        <div class="row">
                                            <!-- column -->
                                            <div class="col-sm-12 col-md-12">
                                                <h4 class="card-title"><?php echo $lang['leftorder118'] ?></h4>
                                                <h5 class="card-subtitle mb-0"><?php echo $lang['left1009'] ?></h5>
                                                <div class="row mt-3">
                                                    <div class="col-2 border-end">
                                                        <i class="ri-checkbox-blank-circle-fill fs-4 text-transit"></i>
                                                        <h3 class="mb-0 font-medium">
                                                            <?php

                                                            $db->cdp_query('SELECT COUNT(*) as total FROM cdb_add_order WHERE status_courier=3');

                                                            $db->cdp_execute();

                                                            $count = $db->cdp_registro();

                                                            echo $count->total;
                                                            ?>

                                                        </h3>
                                                        <span><?php echo $lang['leftorder119'] ?></span>
                                                    </div>
                                                    <div class="col-3 border-end">
                                                        <i class="ri-checkbox-blank-circle-fill fs-4 text-warning-warehouse"></i>
                                                        <h3 class="mb-0 font-medium">
                                                            <?php

                                                            $db->cdp_query('SELECT COUNT(*) as total FROM cdb_add_order WHERE status_courier=4');

                                                            $db->cdp_execute();

                                                            $count = $db->cdp_registro();

                                                            echo $count->total;
                                                            ?>

                                                        </h3>
                                                        <span><?php echo $lang['leftorder120'] ?></span>
                                                    </div>
                                                    <div class="col-2 border-end">
                                                        <i class="ri-checkbox-blank-circle-fill fs-4 text-warning-pending"></i>
                                                        <h3 class="mb-0 font-medium">
                                                            <?php

                                                            $db->cdp_query('SELECT COUNT(*) as total FROM cdb_add_order WHERE status_courier=11');

                                                            $db->cdp_execute();

                                                            $count = $db->cdp_registro();

                                                            echo $count->total;
                                                            ?>
                                                        </h3>
                                                        <span><?php echo $lang['filter71'] ?></span>
                                                    </div>
                                                    <div class="col-2 border-end">
                                                        <i class="ri-checkbox-blank-circle-fill fs-4 text-delivered"></i>
                                                        <h3 class="mb-0 font-medium">
                                                            <?php

                                                            $db->cdp_query('SELECT COUNT(*) as total FROM cdb_add_order WHERE status_courier=8');

                                                            $db->cdp_execute();

                                                            $count = $db->cdp_registro();

                                                            echo $count->total;
                                                            ?>
                                                        </h3>
                                                        <span><?php echo $lang['filter73'] ?></span>
                                                    </div>
                                                    <div class="col-3">
                                                        <a href="accounts_receivable.php">
                                                            <i class="ri-checkbox-blank-circle-fill fs-4 text-warning"></i>
                                                        </a>
                                                        <h3 class="mb-0 font-medium">
                                                            <?php

                                                            $db->cdp_query('SELECT COUNT(*) as total FROM cdb_add_order WHERE status_invoice=2 AND status_courier!=21 and is_consolidate!=1');

                                                            $db->cdp_execute();

                                                            $count = $db->cdp_registro();

                                                            echo $count->total;
                                                            ?>
                                                        </h3>
                                                        <span><a href="accounts_receivable.php"><?php echo $lang['leftorder121'] ?></a></span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- ---------------------
                                    end Order Status
                                ---------------- -->
                            </div>
                        </div>
                    </div>
                </div>

                <!-- -------------------------------------------------------------- -->
                <!-- Table -->
                <!-- -------------------------------------------------------------- -->
                <div class="row">
                    <div class="col-lg-12">
                        <!-- ---------------------
                            start Projects of the Month
                        ---------------- -->
                        <div class="card">

                            <div class="card-body">
                                <div class="d-md-flex align-items-center">
                                    <div>
                                        <h4 class="card-title"><?php echo $lang['leftorder122'] ?></h4>
                                    </div>
                                </div>

                                <div class="tab-content" id="pills-tabContent">
                                    <div class="tab-pane fade show active" id="pills-shipment" role="tabpanel" aria-labelledby="pills-home-tab">
                                        <div class="row">
                                            <!-- column -->
                                            <div class="col-sm-6 col-md-6">
                                                <ul class="nav nav-pills mb-3" id="pills-tab" role="tablist">
                                                    <li class="nav-item">
                                                        <a class="nav-link active" id="pills-home-tab" data-toggle="pill" href="#pills-shipment" role="tab" aria-controls="pills-shipment" aria-selected="true"><?php echo $lang['dashnew19'] ?></a>
                                                    </li>


                                                    <li class="nav-item">
                                                        <a class="nav-link" id="pills-profile-tab" href="consolidate_list.php"><?php echo $lang['dashnew21'] ?></a>
                                                    </li>

                                                </ul>
                                            </div>

                                            <!-- column -->
                                            <div class="col-sm-6 col-md-6 ">

                                                <div class="input-group">
                                                    <input type="text" name="search_shipment" id="search_shipment" class="form-control input-sm float-right" placeholder="<?php echo $lang['leftorder260'] ?>" onkeyup="cdp_load(1);">
                                                    <div class="input-group-append input-sm">
                                                        <button type="submit" class="btn btn-info"><i class="fa fa-search"></i></button>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>

                                        <div class="results_shipments"></div>
                                    </div>

                                    <div class="tab-pane fade" id="pills-consolidated" role="tabpanel" aria-labelledby="pills-contact-tab">
                                        <div class="col-md-4 mt-4 mb-4">
                                            <div class="input-group">
                                                <input type="text" name="search_consolidated" id="search_consolidated" class="form-control input-sm float-right" placeholder="<?php echo $lang['leftorder260'] ?>" onkeyup="cdp_load(1);">
                                                <div class="input-group-append input-sm">
                                                    <button type="submit" class="btn btn-info"><i class="fa fa-search"></i></button>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="results_consolidated"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- --------------------- 
                            end Projects of the Month
                        ---------------- -->
                    </div>
                </div>
                <!-- -------------------------------------------------------------- -->
                <!-- Table -->
                <!-- -------------------------------------------------------------- -->

            </div>
            <!-- -------------------------------------------------------------- -->
            <!-- End Container fluid  -->
            <!-- -------------------------------------------------------------- -->


            <?php include 'views/inc/footer.php'; ?>

            <script src="assets/libs/apexcharts/dist/apexcharts.min.js"></script>

            <script src="dataJs/dashboard_packages_bouncerate_index.js"></script>
            <script src="dataJs/dashboard_area_account_index.js"></script>
            <!-- <script src="dataJs/dashboard_shipments_pie_chart.js"></script> -->
            <script src="dataJs/dashboard_index.js"></script>