<?php
// *************************************************************************
// *                                                                       *
// * DEPRIXA BASIC -  Freight Forwarding & Shipping Software Solutions     *
// * Copyright (c) JAOMWEB. All Rights Reserved                            *
// *                                                                       *
// *************************************************************************
// *                                                                       *
// * Email: support@jaom.info                                              *
// * Website: https://deprixa.link/documentation/                          *
// *                                                                       *
// *************************************************************************
// *                                                                       *
// * This software is furnished under a license and may be used and copied *
// * only  in  accordance  with  the  terms  of such  license and with the *
// * inclusion of the above copyright notice.                              *
// * If you Purchased from Codecanyon, Please read the full License from   *
// * here- http://codecanyon.net/licenses/standard                         *
// *                                                                       *
// *************************************************************************


require_once('helpers/querys.php');

if (isset($_GET['id'])) {
  $data = cdp_getConsolidatePrint($_GET['id']);
}

if (!isset($_GET['id']) or $data['rowCount'] != 1) {
  cdp_redirect_to("consolidate_list.php");
}



$row = $data['data'];

$db->cdp_query("SELECT * FROM cdb_consolidate_detail WHERE consolidate_id='" . $_GET['id'] . "'");
$order_items = $db->cdp_registros();

$db->cdp_query("SELECT * FROM cdb_met_payment where id= '" . $row->order_pay_mode . "'");
$met_payment = $db->cdp_registro();


$db->cdp_query("SELECT * FROM cdb_shipping_mode where id= '" . $row->order_service_options . "'");
$shipping_mode = $db->cdp_registro();

$db->cdp_query("SELECT * FROM cdb_courier_com where id= '" . $row->order_courier . "'");
$courier_com = $db->cdp_registro();

$db->cdp_query("SELECT * FROM cdb_category where id= '" . $row->order_item_category . "'");
$category = $db->cdp_registro();

$fecha = date("Y-m-d :h:i A", strtotime($row->order_datetime));

$db->cdp_query("SELECT * FROM cdb_users where id= '" . $row->receiver_id . "'");
$receiver_data = $db->cdp_registro();



$db->cdp_query("SELECT * FROM cdb_address_shipments where order_track='" . $row->c_prefix . $row->c_no . "'");
$address_order = $db->cdp_registro();

$db->cdp_query("SELECT * FROM cdb_users where id= '" . $row->sender_id . "'");
$sender_data = $db->cdp_registro();


?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">

<head>
  <meta http-equiv='Content-Type' content='text/html; charset=UTF-8' />
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta name="keywords" content="Courier DEPRIXA-Integral Web System" />
  <meta name="author" content="Jaomweb">

  <!-- Favicon icon -->
  <link rel="icon" type="image/png" sizes="16x16" href="assets/uploads/favicon.png">

  <title><?php echo $lang['inv-container37'] ?> - <?php echo $row->c_prefix . $row->c_no; ?></title>

  <!-- Web Fonts
    ======================= -->
  <link rel='stylesheet' href='https://fonts.googleapis.com/css?family=Poppins:100,200,300,400,500,600,700,800,900' type='text/css'>

  <!-- Stylesheet
    ======================= -->
  <link rel="stylesheet" type="text/css" href="assets/vendor/bootstrap/css/bootstrap.min.css" />
  <link rel="stylesheet" type="text/css" href="assets/vendor/font-awesome/css/all.min.css" />
  <link rel="stylesheet" type="text/css" href="assets/dist/css/stylesheet.css" />
  <link rel="stylesheet" href="assets/dist/css/themify-icons.css">
  <!--[if lt IE 8]><!-->
  <link rel="stylesheet" href="assets/dist/css/ie7/ie7.css">
  <style>
    * {
      margin: 0;
      padding: 0;
    }

    body {
      font: 14px/1.4 Helvetica, Arial, sans-serif;
    }

    #page-wrap {
      width: 800px;
      margin: 0 auto;
    }

    textarea {
      border: 0;
      font: 14px Helvetica, Arial, sans-serif;
      overflow: hidden;
      resize: none;
    }

    table {
      border-collapse: collapse;
    }

    table td,
    table th {
      border: 1px solid black;
      padding: 5px;
    }

    tr.noBorder td {
      border: 0;
    }

    td.Border td {
      border: 1px;
    }

    #header {
      height: 15px;
      width: 100%;
      margin: 20px 0;
      background: #222;
      text-align: center;
      color: white;
      font: bold 15px Helvetica, Sans-Serif;
      text-decoration: uppercase;
      letter-spacing: 20px;
      padding: 8px 0px;
    }

    #address {
      width: 250px;
      height: 150px;
      float: left;
    }

    #customer {
      overflow: hidden;
    }

    #logo {
      text-align: right;
      float: right;
      position: relative;
      margin-top: 18px;
      border: 1px solid #fff;
      max-width: 540px;
      overflow: hidden;
    }

    #customer-title {
      font-size: 16px;
      font-weight: bold;
      float: left;
    }

    #meta {
      margin-top: 0px;
      width: 100%;
      float: right;
    }

    #meta td {
      text-align: right;
    }

    #meta td.meta-head {
      text-align: left;
      background: #6c757d;
    }

    #meta tr.meta-head {
      height: 8px;
    }

    #meta td textarea {
      width: 100%;
      height: 10px;
      text-align: right;
    }

    #signing {
      margin-top: 0px;
      width: 100%;
      float: center;
    }

    #signing td {
      text-align: center;
    }

    #signing td.signing-head {
      text-align: center;
      background: #eee;
    }

    #signing td textarea {
      width: 100%;
      height: 20px;
      text-align: center;
    }

    #items {
      clear: both;
      width: 100%;
      margin: 0px 0 0 0;
      border: 1px solid black;
    }

    #items {
      margin-top: 7px;
      width: 100%;
      float: right;
    }

    #items th {
      background: #6c757d;
    }

    #items textarea {
      width: 80px;
      height: 50px;
    }

    #items tr.item-row td {
      vertical-align: top;
    }

    #items td.description {
      width: 300px;
    }

    #items td.item-name {
      width: 175px;
    }

    #items td.description textarea,
    #items td.item-name textarea {
      width: 100%;
    }

    #items td.total-line {
      border-right: 0;
      text-align: right;
    }

    #items td.total-value {
      border-left: 0;
      padding: 7px;
    }

    #items td.total-value textarea {
      height: 20px;
      background: none;
    }

    #items td.balance {
      background: #6c757d;
    }

    #items td.blank {
      border: 0;
    }

    #terms {
      text-align: center;
      margin: 10px 0 0 0;
    }

    #terms h5 {
      text-transform: uppercase;
      font: 13px Helvetica, Sans-Serif;
      letter-spacing: 10px;
      border-bottom: 1px solid black;
      padding: 0 0 8px 0;
      margin: 0 0 8px 0;
    }

    #terms textarea {
      width: 100%;
      text-align: center;
    }
  </style>
</head>

<body>
  <!-- Container -->
  <div id="page-wrap">
    <div class="container-fluid invoice-container">
      <!-- Header -->
      <header>
        <div class="row align-items-center">
          <div class="col-sm-7 text-center text-sm-start mb-3 mb-sm-0">
            <?php echo ($core->logo) ? '<img src="assets/' . $core->logo . '" alt="' . $core->site_name . '" width="' . $core->thumb_w . '" height="' . $core->thumb_h . '"/>' : $core->site_name; ?>
          </div>
          <div class="col-sm-5 text-center text-sm-end">
            <img src='https://barcode.tec-it.com/barcode.ashx?data=<?php echo $row->c_prefix . $row->c_no; ?>&code=Code128&multiplebarcodes=false&translate-esc=false&unit=Fit&dpi=72&imagetype=Gif&rotation=0&color=%23000000&bgcolor=%23ffffff&qunit=Mm&quiet=0&modulewidth=50' alt='' />
          </div>
        </div>
        <hr>
      </header>

      <!-- Main Content -->
      <main>
        <div class="row">
          <div class="col-sm-6 mb-3"> <strong><?php echo $lang['inv-shipping9'] ?>:</strong> <span><?php echo $row->c_prefix . $row->c_no; ?></span> </div>
          <div class="col-sm-6 mb-3 text-sm-end"> <strong><?php echo $lang['inv-shipping8'] ?>:</strong> <span><?php echo $fecha; ?></span> </div>
        </div>
        <hr class="mt-0">
        <div class="row">
          <div class="col-sm-5"> <strong><?php echo $lang['inv-shipping5'] ?>:</strong>
            <address>
              <b><?php echo $sender_data->fname . " " . $sender_data->lname; ?></b><br />
              <?php echo $address_order->sender_address; ?><br />
              <?php echo $address_order->sender_country . " | " . $address_order->sender_city; ?><br />
              <?php echo $sender_data->phone; ?>
            </address>
          </div>
          <div class="col-sm-7">
            <div class="row">
              <div class="col-sm-4"> <strong><?php echo $lang['leftorder29'] ?>:</strong>
                <p><?php if ($category != null) {
                      echo $category->name_item;
                    } ?></p>
              </div>
              <div class="col-sm-4"> <strong><?php echo $lang['inv-shipping7'] ?>:</strong>
                <p><?php if ($courier_com != null) {
                      echo $courier_com->name_com;
                    } ?></p>
              </div>
              <div class="col-sm-4"> <strong><?php echo $lang['add-title22'] ?>:</strong>
                <p><?php if ($shipping_mode != null) {
                      echo $shipping_mode->ship_mode;
                    } ?></p>
              </div>
              <div class="col-sm-4"> <strong><?php echo $lang['inv-shipping6'] ?>:</strong>
                <p><?php echo $met_payment->met_payment; ?></p>
              </div>
              <div class="col-sm-4"> <strong><?php echo $lang['inv-shipping20'] ?>:</strong>
                <p><?php echo $row->seals_package; ?></p>
              </div>
            </div>
          </div>
        </div>
        <div class="card">

          <div class="card-body p-0">
            <div class="table-responsive">
              <table id="items">
                <thead class="card-header">
                  <tr>
                    <td class="col-6 text-center"><strong><?php echo $lang['ltracking'] ?></strong></td>
                    <td class="col-3 text-center"><strong> Weights</strong></td>
                    <td class="col-3 text-end"><strong> Weight Vol.</strong></td>
                  </tr>
                </thead>

                <?php
                $sumador_total = 0;
                $sumador_libras = 0;
                $sumador_volumetric = 0;

                $precio_total = 0;
                $total_impuesto = 0;
                $total_seguro = 0;
                $total_peso = 0;
                $total_descuento = 0;
                $total_impuesto_aduanero = 0;

                foreach ($order_items as $row_order_item) {

                  $weight_item = $row_order_item->weight;

                  $total_metric = $row_order_item->length * $row_order_item->width * $row_order_item->height / $row->volumetric_percentage;

                  // calculate weight x price
                  if ($weight_item > $total_metric) {

                    $calculate_weight = $weight_item;
                    $sumador_libras += $weight_item; //Sumador

                  } else {

                    $calculate_weight = $total_metric;
                    $sumador_volumetric += $total_metric; //Sumador
                  }

                  $precio_total = $calculate_weight * $row->value_weight;
                  $precio_total = number_format($precio_total, 2, '.', ''); //Precio total formateado

                  $sumador_total += $precio_total;

                  if ($sumador_total > $core->min_cost_tax) {

                    $total_impuesto = $sumador_total * $row->tax_value / 100;
                  }

                  $total_descuento = $sumador_total * $row->tax_discount / 100;
                  $total_peso = $sumador_libras + $sumador_volumetric;

                  $total_seguro = $row->tax_insurance_value * $row->tax_insurance_value / 100;

                  $total_impuesto_aduanero = $total_peso * $row->tax_custom_tariffis_value;

                  $total_envio = ($sumador_total - $total_descuento) + $total_impuesto + $total_seguro + $total_impuesto_aduanero + $row->total_reexp;

                  $sumador_total = number_format($sumador_total, 2, '.', '');
                  $sumador_libras = number_format($sumador_libras, 2, '.', '');
                  $sumador_volumetric = number_format($sumador_volumetric, 2, '.', '');
                  $total_envio = number_format($total_envio, 2, '.', '');
                  $total_seguro = number_format($total_seguro, 2, '.', '');
                  $total_peso = number_format($total_peso, 2, '.', '');
                  $total_impuesto_aduanero = number_format($total_impuesto_aduanero, 2, '.', '');
                  $total_impuesto = number_format($total_impuesto, 2, '.', '');
                  $total_descuento = number_format($total_descuento, 2, '.', '');

                ?>
                  <tbody>
                    <tr>
                      <td class="col-6"><?php echo $row_order_item->order_prefix . $row_order_item->order_no; ?></td>
                      <td class="col-3 text-center"><?php echo $weight_item; ?></td>
                      <td class="col-3 text-end"><?php echo $row_order_item->weight_vol; ?></td>
                    </tr>

                  </tbody>
                <?php } ?>

                <tfoot class="card-footer">
                  <tr>
                    <td align="right" class="blank"> </td>
                    <td colspan="1" class="text-end"><strong><?php echo $lang['left240'] ?>:</strong></td>
                    <td class="text-end"><?php echo $sumador_total; ?></td>
                  </tr>
                  <?php if ($core->active_tax1 == 1) { ?>
                    <tr>
                      <td align="right" class="blank"> </td>
                      <td colspan="1" class="text-end"><strong><?php echo $lang['leftorder21'] ?> <?php echo $row->tax_discount; ?> %:</strong></td>
                      <td class="text-end"><?php echo $total_descuento; ?></td>
                    </tr>
                  <?php } ?>

                  <?php if ($core->active_tax2 == 1) { ?>
                    <tr>
                      <td align="right" class="blank"> </td>
                      <td colspan="1" class="text-end"><strong>Tax <?php echo $row->tax_value; ?> %:</strong></td>
                      <td class="text-end" id="impuesto"><?php echo $total_impuesto; ?></td>
                    </tr>
                  <?php } ?>

                  <?php if ($core->active_tax3 == 1) { ?>
                    <tr>
                      <td align="right" class="blank"> </td>
                      <td colspan="1" class="text-end"><strong><?php echo $lang['leftorder25'] ?> <?php echo $row->tax_custom_tariffis_value; ?> %:</strong></td>
                      <td class="text-end" id="total_impuesto_aduanero"><?php echo $total_impuesto_aduanero; ?></td>
                    </tr>
                  <?php } ?>

                  <?php if ($core->active_tax4 == 1) { ?>
                    <tr>
                      <td align="right" class="blank"> </td>
                      <td colspan="1" class="text-end"><strong><?php echo $lang['leftorder24'] ?> <?php echo $row->tax_insurance_value; ?> %:</strong></td>
                      <td class="text-end" id="insurance"><?php echo $total_seguro; ?></td> 
                    </tr>
                  <?php } ?>


                  <?php if ($core->active_tax7 == 1) { ?>
                    <tr>
                      <td align="right" class="blank"> </td>
                      <td colspan="1" class="text-end"><strong><?php echo $lang['leftorder27'] ?>:</strong></td>
                      <td class="text-end" id="impuesto"><?php echo $row->total_reexp; ?></td>
                    </tr>
                  <?php } ?>

                  <tr>
                    <td align="right" class="blank"> </td>
                    <td colspan="1" class="text-end total-line balance"><strong style="color:white;"><?php echo $lang['add-title44'] ?> &nbsp; <?php echo $core->currency; ?>:</strong></td>
                    <td class="text-end total-line balance" id="total_envio"><strong style="color:white;"><?php echo $total_envio; ?></strong></td>
                  </tr>
                </tfoot>
              </table>
            </div>
          </div>
        </div>

        <br>
        <table id="items">
          <tr>
            <td><b><?php echo $lang['left232'] ?>:</b> <span id="total_libras"><?php echo $sumador_libras; ?></span></td>

            <td><b><?php echo $lang['left234'] ?>:</b> <span id="total_volumetrico"><?php echo $sumador_volumetric; ?></span></td>


            <td><b><?php echo $lang['left236'] ?></b>: <span id="total_peso"><?php echo $total_peso; ?></span></td>

          </tr>
        </table>
        <div><br></div>
        <p class="text-1 text-muted"><strong><?php echo $lang['inv-shipping18'] ?>:</strong> <?php echo cdp_cleanOut($core->interms); ?></p>
      </main>
      <!-- Footer -->
      <footer class="text-center">
        <hr>
        <p><strong><?php echo $core->site_name; ?>.</strong><br>
          <?php echo $core->c_address; ?> - <?php echo $core->c_country; ?> - <?php echo $core->c_city; ?>,<br>
          <?php echo $core->site_email; ?>, <?php echo $core->c_phone; ?>. </p>

        <hr>
        <p class="text-1"><strong><?php echo $lang['left485'] ?> :</strong> <?php echo $lang['leftorder214'] ?>.</p>
        <div class="btn-group btn-group-sm d-print-none">

          <button class="btn btn-light border text-black-50 shadow-none" onClick="window.print();" style="font-size:16px"><?php echo $lang['inv-shipping19'] ?>&nbsp;&nbsp; <i class="ti-printer"></i></button>
        </div>
      </footer>
    </div>
  </div>
</body>

</html>