<?php
// *************************************************************************
// *                                                                       *
// * DEPRIXA BASIC -  Freight Forwarding & Shipping Software Solutions     *
// * Copyright (c) JAOMWEB. All Rights Reserved                            *
// *                                                                       *
// *************************************************************************
// *                                                                       *
// * Email: support@jaom.info                                              *
// * Website: https://deprixa.link/documentation/                          *
// *                                                                       *
// *************************************************************************
// *                                                                       *
// * This software is furnished under a license and may be used and copied *
// * only  in  accordance  with  the  terms  of such  license and with the *
// * inclusion of the above copyright notice.                              *
// * If you Purchased from Codecanyon, Please read the full License from   *
// * here- http://codecanyon.net/licenses/standard                         *
// *                                                                       *
// *************************************************************************



require_once('helpers/querys.php');

if (isset($_GET['id'])) {
	$data = cdp_getConsolidatePrint($_GET['id']);
}

if (!isset($_GET['id']) or $data['rowCount'] != 1) {
	cdp_redirect_to("consolidate_list.php");
}



$row_order = $data['data'];

$db->cdp_query("SELECT * FROM cdb_shipping_mode where id= '" . $row_order->order_service_options . "'");
$order_service_options = $db->cdp_registro();

$db->cdp_query("SELECT * FROM cdb_users where id= '" . $row_order->sender_id . "'");
$sender_data = $db->cdp_registro();

$db->cdp_query("SELECT * FROM cdb_users where id= '" . $row_order->receiver_id . "'");
$receiver_data = $db->cdp_registro();


$db->cdp_query("SELECT * FROM cdb_delivery_time where id= '" . $row_order->order_deli_time . "'");
$delivery_time = $db->cdp_registro();

$db->cdp_query("SELECT * FROM cdb_styles where id= '" . $row_order->status_courier . "'");
$status_courier = $db->cdp_registro();

$db->cdp_query("SELECT * FROM cdb_courier_com where id= '" . $row_order->order_courier . "'");
$courier_com = $db->cdp_registro();


$db->cdp_query("SELECT * FROM cdb_address_shipments where order_track='" . $row_order->c_prefix . $row_order->c_no . "'");
$address_order = $db->cdp_registro();


$db->cdp_query("SELECT * FROM cdb_consolidate_detail WHERE consolidate_id='" . $row_order->consolidate_id . "'");
$order_items = $db->cdp_registros();

$db->cdp_query("SELECT * FROM cdb_met_payment where id= '" . $row_order->order_pay_mode . "'");
$met_payment = $db->cdp_registro();

$sumador_libras = 0;
$sumador_volumetric = 0;
$count = 0;
foreach ($order_items as $row_item) {

	$weight_item = $row_item->weight;

	$total_metric = $row_item->length * $row_item->width * $row_item->height / $row_order->volumetric_percentage;

	// calculate weight x price
	if ($weight_item > $total_metric) {

		$calculate_weight = $weight_item;
		$sumador_libras += $weight_item; //Sumador

	} else {

		$calculate_weight = $total_metric;
		$sumador_volumetric += $total_metric; //Sumador
	}

	$count++;
}


?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">

<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<!-- Favicon icon -->
	<title>Tracking - <?php echo $row_order->c_prefix . $row_order->c_no; ?></title>
	<link type='text/css' href='assets/dist/css/label_custom.css' rel='stylesheet' />
	<link rel="stylesheet" href="assets/dist/css/themify-icons.css">
	<!--[if lt IE 8]><!-->
	<link rel="stylesheet" href="assets/dist/css/ie7/ie7.css">

</head>

<body>
	<div id="page-wrap">

		<div class="container_etiqueta" style="min-height: 540px; max-height: 540px; min-width: 420px; max-width: 420px;">
			<div class="print_ticket_zebra" style="max-height: 110px; min-height: 110px;">
				<div style="width: 30%;line-height:110px;margin:0px auto;text-align:center;">

					<?php echo ($core->logo) ? '<img src="assets/' . $core->logo . '" alt="' . $core->site_name . '" width="' . $core->thumb_w . '" height="' . $core->thumb_h . '"/>' : $core->site_name; ?>
				</div>
				<div style="width: 70%;">
					<strong><?php echo $core->site_name; ?><br></strong>

					<?php echo $core->c_country; ?>, <?php echo $core->c_city; ?>, <?php echo $core->c_postal; ?>.<br>
					TEL: <?php echo $core->c_phone; ?>
				</div>
			</div>
			<div class="app_print_ticket_zebra" style="margin-top: -18px; height: 100px; max-width: 420px; margin-left: 22px">
				<img style="width: 380px; min-height: 100px; max-height: 100px;" src='https://barcode.tec-it.com/barcode.ashx?data=<?php echo $row_order->c_prefix . $row_order->c_no; ?>&code=EANUCC128&multiplebarcodes=false&translate-esc=true&unit=Fit&dpi=96&imagetype=Gif&rotation=0&color=%23000000&bgcolor=%23ffffff&qunit=Mm&quiet=0' alt='' />
			</div>
			<div class="app_easypack_ticket_zebra" style="padding-top:50px; max-width: 420px; text-align: center">
				<div class="track_courier"><strong> <?php echo $row_order->c_prefix . $row_order->c_no; ?></strong></div>
			</div>
			<div class="app_easypack_print" style="padding-top: 5px;font-weight: bold">
				<div>Package ref: &nbsp;</div>
				<div>&nbsp;</div>
			</div>
			<div class="datas_easypack_print">
				<div>Date: &nbsp;<?php echo $row_order->c_date; ?> &nbsp;|&nbsp;Qnty: &nbsp;<?php echo $count; ?>&nbsp;|&nbsp;W: &nbsp;<?php if ($sumador_libras > $sumador_volumetric) {
																																			echo  cdp_round_out($sumador_libras);
																																		} else {
																																			echo cdp_round_out($sumador_volumetric);
																																		} ?>&nbsp;|&nbsp;USFOB: &nbsp;<?php echo $row_order->total_order; ?> </div>
			</div>
			<div class="app_easypack_print">
				<div>L : <?php echo $row_item->length; ?> &nbsp;</div>
				<div>W : <?php echo $row_item->width; ?> H : <?php echo $row_item->height; ?></div>
			</div>


			<div class="app_easypack_print">
				<div><strong>REF. SERVICE: </strong>&nbsp;</div>
				<div><?php if ($order_service_options != null) {
							echo $order_service_options->ship_mode;
						} ?> &nbsp;|&nbsp; <?php if ($courier_com != null) {
												echo $courier_com->name_com;
											} ?></div>
			</div>

			<div class="app_easypack_ticket_zebra" style="padding-top: 3px; padding-bottom: 3px; font-size: 22px; max-height: 18px; min-height: 25px;">
				<strong><?php if ($met_payment != null) {
							echo $met_payment->met_payment;
						} ?></strong>
			</div>

			<br>
			<div class="app_easypack_ticket_zebra" style="font-size: 37px; margin-top: 1px; margin-left: 0px; ">
				<strong><?php echo $address_order->recipient_country . " - " . $address_order->recipient_city; ?></strong>
			</div>
			<div class="app_easypack_qr_code" style="max-height: 110px; min-height: 110px;">
				<div style="width: 30%;">
					<img src='https://barcode.tec-it.com/barcode.ashx?data=Tracking:+<?php echo $row_order->c_prefix . $row_order->c_no; ?>&code=QRCode&multiplebarcodes=false&translate-esc=false&unit=Fit&dpi=72&imagetype=Gif&rotation=0&color=%23000000&bgcolor=%23ffffff&qunit=Mm&quiet=0&eclevel=L' alt='' />
				</div>
				<div style="width: 70%;">
					<?php echo $receiver_data->fname; ?> <?php echo $receiver_data->lname; ?> <br>
					<?php echo $address_order->recipient_address . " <br> " . $receiver_data->phone; ?>
				</div>
			</div>
		</div>

		<br><br><br><br><br><br><br>
		<button class='button -dark center no-print' onClick="window.print();" style="font-size:16px">Print label &nbsp;&nbsp; <li class="ti-printer"></i></button>
	</div>
</body>

</html>