<?php
// *************************************************************************
// *                                                                       *
// * DEPRIXA BASIC -  Freight Forwarding & Shipping Software Solutions     *
// * Copyright (c) JAOMWEB. All Rights Reserved                            *
// *                                                                       *
// *************************************************************************
// *                                                                       *
// * Email: support@jaom.info                                              *
// * Website: https://deprixa.link/documentation/                          *
// *                                                                       *
// *************************************************************************
// *                                                                       *
// * This software is furnished under a license and may be used and copied *
// * only  in  accordance  with  the  terms  of such  license and with the *
// * inclusion of the above copyright notice.                              *
// * If you Purchased from Codecanyon, Please read the full License from   *
// * here- http://codecanyon.net/licenses/standard                         *
// *                                                                       *
// *************************************************************************


header('Content-Type: text/html; charset=UTF-8');
header("Content-Type:   application/vnd.ms-excel; charset=utf-8");
header("Content-Disposition: attachment; filename=Report_manifest_shipment_general" . date('d-m-Y') . ".xls");
header("Expires: 0");
header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
header("Cache-Control: private", false);



$db = new Conexion;
$user = new User;
$core = new Core;
$userData = $user->cdp_getUserData();

$status_courier = intval($_REQUEST['status_courier']);
$method = intval($_REQUEST['method']);
$agency = intval($_REQUEST['agency']);
$range = $_REQUEST['range'];
$customer_id = intval($_REQUEST['customer_id']);


$sWhere = "";


if ($status_courier > 0) {

	$sWhere .= " and  a.status_courier = '" . $status_courier . "'";
}

if ($customer_id > 0) {

	$sWhere .= " and a.sender_id = '" . $customer_id . "'";
}


if ($agency > 0) {

	$db->cdp_query("SELECT * FROM cdb_branchoffices where id= '" . $agency . "'");
	$agencys = $db->cdp_registro();

	$agencyFilter = $agencys->name_branch;

	$sWhere .= " and a.agency = '" . $agency . "'";
} else {

	$agencyFilter = 'All';
}

if ($method > 0) {

	$sWhere .= " and a.order_payment_method = '" . $method . "'";
}

if ($userData->userlevel == 3) {

	$sWhere .= " and  a.driver_id = '" . $_SESSION['userid'] . "'";
}



if (!empty($range)) {

	$fecha =  explode(" - ", $range);
	$fecha = str_replace('/', '-', $fecha);

	$fecha_inicio = date('Y-m-d', strtotime($fecha[0]));
	$fecha_fin = date('Y-m-d', strtotime($fecha[1]));


	$sWhere .= " and  a.order_date between '" . $fecha_inicio . "'  and '" . $fecha_fin . "'";
}

$sql = "SELECT a.total_declared_value, a.total_weight, a.total_tax_discount, a.sub_total, a.total_tax_insurance, a.total_tax_custom_tariffis, a.total_tax, a.status_invoice,  a.total_fixed_value,  a.is_consolidate, a.is_pickup,  a.total_order, a.order_id, a.order_prefix, a.order_no, a.order_date, a.sender_id, a.receiver_id,  a.order_courier,a.status_courier,  b.mod_style, b.color FROM
	 cdb_add_order as a
	 INNER JOIN cdb_styles as b ON a.status_courier = b.id
	 $sWhere
	  and a.status_courier!=14 
	  and a.is_consolidate!=1

	 order by a.order_id desc 
	 ";


$query_count = $db->cdp_query($sql);
$db->cdp_execute();
$numrows = $db->cdp_rowCount();


$db->cdp_query($sql);
$data = $db->cdp_registros();

$fecha = str_replace('-', '/', $fecha);

$html = '
	<html>
		<body>
		
		<h2>' . $core->site_name . '<br>
		'.$lang['report-general036'].' <br>

		[' . $fecha[0] . ' - ' . $fecha[1] . ']
		<br>
		'.$lang['left324'].': ' . $agencyFilter . '

		</h2>


		<table border=1>
		<tbody>
			<tr style="background-color: #3e5569; color: white">				
				<th><b></b></th>
				<th class="text-center"><b>' . utf8_encode($lang['ltracking']) . '</b></th>
				<th class="text-center"><b>' . utf8_encode($lang['ddate']) . '</b></th>
				<th class="text-center"><b>' . utf8_encode($lang['left332']) . '</b></th>
				<th class="text-center"><b>' . utf8_encode($lang['left473']) . '</b></th>
				<th class="text-center"><b>' . utf8_encode($lang['left464']) . '</b></th>
				<th class="text-center"><b>' . utf8_encode($lang['left463']) . '</b></th>
				<th class="text-center"><b>' . utf8_encode($lang['left499']) . '</b></th>
				<th class="text-center"><b>' . utf8_encode($lang['left473']) . '</b></th>
				<th class="text-center"><b>' . utf8_encode($lang['left464']) . '</b></th>
				<th class="text-center"><b>' . utf8_encode($lang['left463']) . '</b></th>
				<th class="text-center"><b>' . utf8_encode($lang['langs_044']) . '</b></th>
				<th class="text-center"><b>' . utf8_encode($lang['langs_08']) . '</b></th>
				<th class="text-center"><b>' . utf8_encode($lang['lstatusshipment']) . '</b></th>
			</tr>';

if ($numrows > 0) {

	$count = 0;

	foreach ($data as $row) {

		$db->cdp_query("SELECT * FROM cdb_users where id= '" . $row->sender_id . "'");
		$sender_data = $db->cdp_registro();

		$db->cdp_query("SELECT * FROM cdb_users where id= '" . $row->receiver_id . "'");
		$receiver_data = $db->cdp_registro();

		$db->cdp_query("SELECT * FROM cdb_add_order_item where order_id='" . $row->order_id . "'");
		$add_orderitem = $db->cdp_registro();


		$db->cdp_query("SELECT * FROM cdb_courier_com where id= '" . $row->order_courier . "'");
		$courier_com = $db->cdp_registro();


		$db->cdp_query("SELECT * FROM cdb_styles where id= '14'");
		$status_style_pickup = $db->cdp_registro();

		$db->cdp_query("SELECT * FROM cdb_styles where id= '13'");
		$status_style_consolidate = $db->cdp_registro();

		$db->cdp_query("SELECT * FROM cdb_address_shipments where order_track='" . $row->order_prefix . $row->order_no . "'");
		$address_order = $db->cdp_registro();


		if ($row->status_invoice == 1) {

			$text_status = $lang['invoice_paid'];
			$label_class = "badge bg-light-success text-success fw-normal";
		} else if ($row->status_invoice == 2) {

			$text_status = $lang['invoice_pending'];
			$label_class = "badge bg-light-warning text-warning fw-normal";
		} else if ($row->status_invoice == 3) {
			$text_status = $lang['invoice_due'];
			$label_class = "badge bg-light-danger text-danger fw-normal";
		}


		$count++;


		$html .= '<tr>';
		$html .= '<td ><b>' . $count . '</b></td>';
		$html .= '<td>' . $row->order_prefix . $row->order_no . '</td>';
		$html .= '<td>' . $row->order_date . '</td>';
		$html .= '<td>' . $sender_data->fname . ' ' . $sender_data->lname . '</td>';
		$html .= '<td>' . $address_order->sender_address . '-' . $address_order->sender_city . '</td>';
		$html .= '<td>' . $sender_data->phone . '</td>';
		$html .= '<td>' . $sender_data->email . '</td>';
		$html .= '<td>' . $receiver_data->fname . ' ' . $receiver_data->lname . '</td>';
		$html .= '<td>' . $address_order->recipient_address . '-' . $address_order->recipient_city . '</td>';
		$html .= '<td>' . $receiver_data->phone . '</td>';
		$html .= '<td>' . $receiver_data->email . '</td>';
		$html .= '<td>' . $add_orderitem->order_item_quantity . '</td>';
		$html .= '<td>' . $add_orderitem->order_item_description . '</td>';
		$html .= '<td>' . $text_status . '</td>';
		$html .= '</tr>';
	}

}

$html .= '</table></html>';
echo utf8_decode($html);
