<?php
// *************************************************************************
// *                                                                       *
// * DEPRIXA BASIC -  Freight Forwarding & Shipping Software Solutions     *
// * Copyright (c) JAOMWEB. All Rights Reserved                            *
// *                                                                       *
// *************************************************************************
// *                                                                       *
// * Email: support@jaom.info                                              *
// * Website: https://deprixa.link/documentation/                          *
// *                                                                       *
// *************************************************************************
// *                                                                       *
// * This software is furnished under a license and may be used and copied *
// * only  in  accordance  with  the  terms  of such  license and with the *
// * inclusion of the above copyright notice.                              *
// * If you Purchased from Codecanyon, Please read the full License from   *
// * here- http://codecanyon.net/licenses/standard                         *
// *                                                                       *
// *************************************************************************



require_once('helpers/querys.php');


if (isset($_GET['order_track'])) {

	$results = cdp_getCourierTrack($_GET['order_track']);

	$track = $results['data'];
} else {

	cdp_redirect_to("tracking.php");
}



$db->cdp_query("

	SELECT a.id, a.order_track, a.t_dest, a.t_date, a.t_city, a.comments, a.status_courier, b.mod_style FROM cdb_courier_track as a

	INNER JOIN cdb_styles as b ON a.status_courier = b.id 

	where a.order_track='" . $_GET['order_track'] . "' ORDER BY a.id DESC");

$courier_track = $db->cdp_registros();
if ($track != null) {


	$db->cdp_query("SELECT * FROM cdb_users where id= '" . $track->sender_id . "'");
	$sender_data = $db->cdp_registro();

	$db->cdp_query("SELECT * FROM cdb_users where id= '" . $track->receiver_id . "'");
	$receiver_data = $db->cdp_registro();

	$db->cdp_query("SELECT * FROM cdb_delivery_time where id= '" . $track->order_deli_time . "'");
	$delivery_time = $db->cdp_registro();


	$db->cdp_query("SELECT * FROM cdb_address_shipments where order_track='" . $track->order_prefix . $track->order_no . "'");
	$address_order = $db->cdp_registro();


	$db->cdp_query("SELECT SUM(order_item_length) as total0 from cdb_add_order_item where order_id='" . $track->order_id . "'");
	$db->cdp_execute();
	$row0 = $db->cdp_registro();

	$rw_add0 = $row0->total0;


	// volumetric query of the box width

	$db->cdp_query("SELECT SUM(order_item_width) as total1 from cdb_add_order_item where order_id='" . $track->order_id . "'");
	$db->cdp_execute();
	$row1 = $db->cdp_registro();

	$rw_add1 = $row1->total1;

	// volumetric query of the box width

	$db->cdp_query("SELECT SUM(order_item_height) as total2 from cdb_add_order_item where order_id='" . $track->order_id . "'");
	$db->cdp_execute();
	$row2 = $db->cdp_registro();

	$rw_add2 = $row2->total2;

	$length = $rw_add0; //Length
	$width = $rw_add1; //Width
	$height = $rw_add2; //Height


	$total_metric = $length * $width * $height / $track->volumetric_percentage;


	$db->cdp_query("SELECT * FROM cdb_add_order_item WHERE order_id='" . $track->order_id . "'");
	$order_items = $db->cdp_registros();



	$sumador_libras = 0;
	$sumador_volumetric = 0;
	$count = 0;
	foreach ($order_items as $row_item) {

		$weight_item = $row_item->order_item_weight;

		$total_metric = $row_item->order_item_length * $row_item->order_item_width * $row_item->order_item_height / $track->volumetric_percentage;

		// calculate weight x price
		if ($weight_item > $total_metric) {

			$calculate_weight = $weight_item;
			$sumador_libras += $weight_item; //Sumador

		} else {

			$calculate_weight = $total_metric;
			$sumador_volumetric += $total_metric; //Sumador
		}

		$count++;
	}
}

?>
<!DOCTYPE html>
<html lang="en" data-theme="system">

<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0 shrink-to-fit=no">
	<meta http-equiv="X-UA-Compatible" content="ie=edge">
	<meta name="keywords" content="Courier DEPRIXA-Integral Web System">
	<meta name="author" content="Jaomweb">
	<meta name="description" content="">
	<title><?php echo $lang['leftorder284'] ?> | <?php echo $core->site_name; ?></title>
	<link rel="icon" type="image/png" sizes="16x16" href="assets/<?php echo $core->favicon ?>">

	<link href="https://fonts.googleapis.com/css2?family=Work+Sans:wght@400;500;600&amp;display=swap" rel="stylesheet">
	<link href="assets/dist/css/screen.min.css" rel="stylesheet">
	<link rel="stylesheet" type="text/css" href="assets/dist/css/cards.min.css">
	<link rel="stylesheet" href="assets/dist/css/themify-icons.css">
	<!--[if lt IE 8]><!-->
	<link rel="stylesheet" href="assets/dist/css/ie7/ie7.css">

</head>

<body class="page-template page-tags" data-nav="sticky">
	<div class="site-wrap">
		<header class="site-header">
			<div class="container header-inner justify-space-between">
				<div class="header-logo flex">
					<a href="index.php" class="">

						<?php echo ($core->logo_web) ? '<img src="assets/' . $core->logo_web . '" alt="' . $core->site_name . '" width="' . $core->thumb_web . '" height="' . $core->thumb_hweb . '"/>' : $core->site_name; ?>
					</a>
				</div>

				<input id="mobile-menu-toggle" class="mobile-menu-checkbox" type="checkbox">
				<label for="mobile-menu-toggle" class="mobile-menu-icon" aria-label="menu toggle button">
					<span class="line"></span>
					<span class="line"></span>
					<span class="line"></span>
					<span class="sr-only">Menu toggle button</span>
				</label>
				<div class="header-right flex" data-theme-icon="true">
					<nav class="header-nav" role="navigation" aria-label="Main navigation">
						<ul class="header-nav-list no-style-list" role="menu">
							<li class="nav-item" role="menuitem">
								<a href="index.php"><?php echo $lang['left111'] ?></a>
							</li>
							<li class="nav-item" role="menuitem">
								<a href="about_us.php"><?php echo $lang['left123_ab'] ?></a>
							</li>

							<li class="nav-item" role="menuitem">
								<a href="track.php" class="nav-current"><?php echo $lang['left113'] ?></a>
							</li>

							<li class="nav-item" role="menuitem">
								<a href="view.php"><?php echo $lang['left168'] ?></a>
							</li>
							<li class="nav-item" role="menuitem">
								<a class="btn btn-menuitem" href="sign-up.php"><?php echo $lang['tools-login7'] ?></a>
							</li>
						</ul>
					</nav>

				</div>
			</div>
		</header>

		<div><br><br></div>

		<div class="main">
			<div class="container">
				<div class="centered-page-header text-center">
					<h1 class="title"><?php echo $lang['leftorder284'] ?></h1>
					<div class="description">

					</div>
				</div>

				<div class="row">

					<?php if (!$track) : ?>
						<!--============================= TRACKING NOT FOUND =============================-->

						<div class="centered-page-header text-center">
							<div class="row justify-content-center">
								<?php echo "
							<div class='col-lg-12 col-md-12 text-center'>
								<img src='assets/images/alert/ohh_shipment_rate.png' class='img-fluid' alt=''/>
								<div class='text-uppercase mt-4 display-4'>Oh ! no</div>
								<div class='text-capitalize text-dark mb-4 display-6'>" . $lang['track-shipment1'] . " <strong style='color:#FF0000;'>" . $_GET['order_track'] . " </strong></div>
								<p class='text-muted para-desc mx-auto'><span class='text-primary font-weight-bold'>" . $lang['track-shipment2'] . "</span></p>
							</div>
						", false; ?>
							</div>

							<div class="row">
								<div class="col-md-12 text-center">
									<a href="tracking.php" class="btn btn-info"><?php echo $lang['left182'] ?></a>
									<a href="index.php" class="btn btn-primary"><?php echo $lang['left183'] ?></a>
								</div>
							</div>
						</div>

						<!--//END TRACKING NOT FOUND -->
					<?php else : ?>


						<div class="col-xl-7 col-lg-7 col-md-7 tag-card-wrap">
							<div class="row">
								<div class="col-md-4">
									<div class="noticia">
										<img class="izquierda" src="assets/images/content_web/tracking.png">
										<aside><?php echo $track->mod_style; ?></aside>
									</div>
								</div>
								<div class="col-md-4">
									<div class="trackstatus-title">
										<label><?php echo $lang['track-shipment4'] ?> <br><b><?php echo $track->order_prefix . $track->order_no; ?></b></label>
									</div>
								</div>

								<div class="col-md-2">
									<div class="trackstatus-title">

										<a class="btn btn-primary btn-sm  rounded" target="blank" href="print_inv_ship_track.php?id=<?php echo $track->order_id; ?>"><i style="color:white" class="ti-printer"></i>&nbsp;<?php echo $lang['toolprint'] ?></a>

									</div>
								</div>
							</div>
							<div><br></div>

							<div style="visibility: hidden; position: absolute; width: 0px; height: 0px;">
								<svg xmlns="http://www.w3.org/2000/svg">
									<symbol viewBox="0 0 24 24" id="expand-more">
										<path d="M16.59 8.59L12 13.17 7.41 8.59 6 10l6 6 6-6z" />
										<path d="M0 0h24v24H0z" fill="none" />
									</symbol>
									<symbol viewBox="0 0 24 24" id="close">
										<path d="M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z" />
										<path d="M0 0h24v24H0z" fill="none" />
									</symbol>
								</svg>
							</div>

							<details>
								<summary>
									<?php echo $lang['leftorder271'] ?> - <?php echo $lang['track-shipment5'] ?>
									<svg class="control-icon control-icon-expand" width="24" height="24" role="presentation">
										<use xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#expand-more" />
									</svg>
									<svg class="control-icon control-icon-close" width="24" height="24" role="presentation">
										<use xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#close" />
									</svg>
								</summary>

								<!-- General Information -->
								<span class="letter_f">
									<div class="row">
										<div class="col-md-12">
											<div class="track-title c-tracking-result--moredetails-content">
												<h5 class="form_sub"><?php echo $lang['track-shipment5'] ?></h5>
											</div>
										</div>
									</div>

									<div class="archive-post-card pm-6">
										<article class="archive-post">
											<ul>
												<li>
													<div class="inner">
														<time class="post-date" datetime="2021-05-02"><?php echo $lang['track-shipment6'] ?> -</time>
														<div class="track-title">
															<?php echo $address_order->sender_country; ?> -
															<?php echo $address_order->sender_city; ?>

														</div>
													</div>
												</li>


												<li>
													<div class="row">
														<div class="col-md-12">
															<div class="inner">
																<time class="post-date" datetime="2021-05-02"><?php echo $lang['track-shipment20'] ?> - </time>
																<div class="track-title">
																	<?php echo $sender_data->fname . " " . $sender_data->lname; ?>
																</div>
															</div>
														</div>

														<div class="col-md-12">
															<div class="inner">
																<time class="post-date" datetime="2021-05-02"><?php echo $lang['track-shipment10'] ?> - </time>
																<div class="track-title">
																	<?php echo $address_order->sender_address; ?>
																</div>
															</div>
														</div>
													</div>
												</li>

												<li>
													<div class="row">
														<div class="col-md-6">
															<div class="inner">
																<time class="post-date" datetime="2021-05-02"><?php echo $lang['track-shipment8'] ?> -</time>
																<div class="track-title">
																	<?php echo $track->order_date; ?>
																</div>
															</div>
														</div>

														<div class="col-md-6">
															<div class="inner">
																<time class="post-date" datetime="2021-05-02"><?php echo $lang['track-shipment9'] ?> -</time>
																<div class="track-title">
																	<?php if ($delivery_time != null) {
																		echo $delivery_time->delitime;
																	} ?>
																</div>
															</div>
														</div>
													</div>
												</li>

												<li>
													<div class="row">
														<div class="col-md-6">
															<div class="inner">
																<time class="post-date" datetime="2021-05-02"><?php echo $lang['track-shipment11'] ?> -</time>
																<div class="track-title">
																	<?php echo $count; ?>
																</div>
															</div>
														</div>

														<div class="col-md-6">
															<div class="inner">
																<time class="post-date" datetime="2021-05-02"><?php echo $lang['track-shipment13'] ?> -</time>
																<div class="track-title">
																	<?php if ($sumador_libras > $sumador_volumetric) {
																		echo  cdp_round_out($sumador_libras);
																	} else {
																		echo cdp_round_out($sumador_volumetric);
																	} ?>
																</div>
															</div>
														</div>

													</div>
												</li>
											</ul>

										</article>
									</div>
								</span>
								<!--// General Information -->
							</details>

							<details>

								<summary>
									<?php echo $lang['leftorder271'] ?> - <?php echo $lang['track-shipment15'] ?>
									<svg class="control-icon control-icon-expand" width="24" height="24" role="presentation">
										<use xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#expand-more" />
									</svg>
									<svg class="control-icon control-icon-close" width="24" height="24" role="presentation">
										<use xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#close" />
									</svg>
								</summary>
								<span class="letter_f">
									<div class="row">
										<div class="col-md-12">
											<div class="track-title c-tracking-result--moredetails-content">
												<h5 class="form_sub"><?php echo $lang['track-shipment15'] ?></h5>
											</div>
										</div>
									</div>

									<div class="archive-post-card pm-6">
										<article class="archive-post">

											<ul>
												<li>
													<div class="inner">
														<time class="post-date" datetime="2021-05-02"><?php echo $lang['track-shipment16'] ?> -</time>
														<div class="track-title">
															<?php echo $address_order->recipient_city; ?> -
															<?php echo $address_order->recipient_city; ?>

														</div>
													</div>
												</li>

												<li>
													<div class="row">
														<div class="col-md-12">
															<div class="inner">
																<time class="post-date" datetime="2021-05-02"><?php echo $lang['track-shipment20'] ?> - </time>
																<div class="track-title">
																	<?php echo $receiver_data->fname . " " . $receiver_data->lname; ?>
																</div>
															</div>
														</div>

														<div class="col-md-12">
															<div class="inner">
																<time class="post-date" datetime="2021-05-02"><?php echo $lang['track-shipment10'] ?> - </time>
																<div class="track-title">
																	<?php echo $address_order->recipient_address; ?>
																</div>
															</div>
														</div>
													</div>
												</li>

												<li>
													<div class="row">
														<div class="col-md-12">
															<div class="inner">
																<time class="post-date" datetime="2021-05-02"><?php echo $lang['track-shipment9'] ?> -</time>
																<div class="track-title">
																	<?php if ($delivery_time != null) {
																		echo $delivery_time->delitime;
																	} ?>
																</div>
															</div>
														</div>

														<div class="col-md-12">
															<div class="inner">
																<time class="post-date" datetime="2021-05-02"><?php echo $lang['track-shipment19'] ?> -</time>
																<div class="track-title">
																	<?php echo $track->order_datetime; ?>
																</div>
															</div>
														</div>
													</div>
												</li>
											</ul>
										</article>
									</div>
								</span>
							</details>

						</div>

					<?php endif; ?>

					<?php if (!$courier_track) : ?>

					<?php else : ?>


						<div class="col-xl-5 col-lg-5 col-md-5 tag-card-wrap">
							<h5><?php echo $lang['track-shipment22'] ?></h5>
							<?php foreach ($courier_track  as $rows) : ?>

								<div class="archive-wrap">
									<div class="archive-post-card pm-5">
										<div class="pm">
											<span class="ti-package"></span><span class="icon-name"> <?php echo $rows->mod_style; ?></span>
										</div>

										<?php

										if ($rows->t_dest != null) {
											echo $rows->t_dest;
										}

										if ($rows->t_city != null) {
											echo ', ' . $rows->t_city;
										}

										?>

										<time class="post-date" datetime="2021-05-02">
											<?php echo date('Y/m/d', strtotime($rows->t_date)); ?> - <?php echo date('h:i:s a', strtotime($rows->t_date)); ?></time>
										<article class="archive-post">
											<div class="inner">
												<h4 class="form_title">
													<?php echo $rows->comments; ?>
												</h4>
											</div>
										</article>
									</div>
								</div>
							<?php endforeach; ?>
						<?php endif; ?>
						</div>
				</div>
			</div>
		</div>


		<footer class="site-footer">
			<div class="container">

				<div class="footer-bottom flex justify-space-between">
					<div class="social-links-wrap flex">
						<span class="title"><?php echo $lang['leftorder277'] ?></span>
						<div class="social-links flex">
							<a href="#" aria-label="twitter link"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
									<path d="M24 4.557c-.883.392-1.832.656-2.828.775 1.017-.609 1.798-1.574 2.165-2.724-.951.564-2.005.974-3.127 1.195-.897-.957-2.178-1.555-3.594-1.555-3.179 0-5.515 2.966-4.797 6.045-4.091-.205-7.719-2.165-10.148-5.144-1.29 2.213-.669 5.108 1.523 6.574-.806-.026-1.566-.247-2.229-.616-.054 2.281 1.581 4.415 3.949 4.89-.693.188-1.452.232-2.224.084.626 1.956 2.444 3.379 4.6 3.419-2.07 1.623-4.678 2.348-7.29 2.04 2.179 1.397 4.768 2.212 7.548 2.212 9.142 0 14.307-7.721 13.995-14.646.962-.695 1.797-1.562 2.457-2.549z"></path>
								</svg></a>
							<a href="#" aria-label="facebook link"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
									<path d="M9 8h-3v4h3v12h5v-12h3.642l.358-4h-4v-1.667c0-.955.192-1.333 1.115-1.333h2.885v-5h-3.808c-3.596 0-5.192 1.583-5.192 4.615v3.385z"></path>
								</svg></a>
							<a href="#" aria-label="instagram link"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
									<path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z"></path>
								</svg></a>
							<a href="#" aria-label="github link"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
									<path d="M12 0c-6.626 0-12 5.373-12 12 0 5.302 3.438 9.8 8.207 11.387.599.111.793-.261.793-.577v-2.234c-3.338.726-4.033-1.416-4.033-1.416-.546-1.387-1.333-1.756-1.333-1.756-1.089-.745.083-.729.083-.729 1.205.084 1.839 1.237 1.839 1.237 1.07 1.834 2.807 1.304 3.492.997.107-.775.418-1.305.762-1.604-2.665-.305-5.467-1.334-5.467-5.931 0-1.311.469-2.381 1.236-3.221-.124-.303-.535-1.524.117-3.176 0 0 1.008-.322 3.301 1.23.957-.266 1.983-.399 3.003-.404 1.02.005 2.047.138 3.006.404 2.291-1.552 3.297-1.23 3.297-1.23.653 1.653.242 2.874.118 3.176.77.84 1.235 1.911 1.235 3.221 0 4.609-2.807 5.624-5.479 5.921.43.372.823 1.102.823 2.222v3.293c0 .319.192.694.801.576 4.765-1.589 8.199-6.086 8.199-11.386 0-6.627-5.373-12-12-12z" />
								</svg></a>
						</div>
					</div>

					<div class="copyright">
						&copy; <?php echo date('Y') ?> <a href="index.php"><?php echo $core->site_name; ?></a> - <?php echo $lang['foot'] ?> </a>
					</div>
				</div>
			</div>
		</footer>

	</div>


	<script src="assets/dist/js/app.bundle.min.js"></script>
	<script src="assets/dist/js/plugin/prism.js"></script>
	<script src="assets/libs/jquery/dist/jquery.min.js"></script>
	<script src="dataJs/tracking.js"></script>
</body>


</html>